/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.EmbeddedEncoder;
import groovyx.net.http.MultipartContent;
import groovyx.net.http.ToServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class CoreEncoders {
    public static void multipart(ChainedHttpConfig config, ToServer ts) {
        try {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            Object body = request.actualBody();
            if (!(body instanceof MultipartContent)) {
                throw new IllegalArgumentException("Multipart body content must be MultipartContent.");
            }
            String contentType = request.actualContentType();
            if (!contentType.equals(ContentTypes.MULTIPART_FORMDATA.getAt(0)) && !contentType.equals(ContentTypes.MULTIPART_MIXED.getAt(0))) {
                throw new IllegalArgumentException("Multipart body content must be multipart/form-data.");
            }
            MimeMultipart mimeMultipart = new MimeMultipart();
            for (MultipartContent.MultipartPart mpe : ((MultipartContent)body).parts()) {
                mimeMultipart.addBodyPart((BodyPart)CoreEncoders.part(config, mpe));
            }
            request.setContentType(mimeMultipart.getContentType());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            mimeMultipart.writeTo((OutputStream)bytesOut);
            ts.toServer(new ByteArrayInputStream(bytesOut.toByteArray()));
        }
        catch (IOException | MessagingException ioe) {
            ioe.printStackTrace();
        }
    }

    private static MimeBodyPart part(ChainedHttpConfig config, MultipartContent.MultipartPart multipartPart) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDisposition("form-data");
        if (multipartPart.getFileName() != null) {
            bodyPart.setFileName(multipartPart.getFileName());
            bodyPart.setHeader("Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", multipartPart.getFieldName(), multipartPart.getFileName()));
        } else {
            bodyPart.setHeader("Content-Disposition", String.format("form-data; name=\"%s\"", multipartPart.getFieldName()));
        }
        bodyPart.setDataHandler(new DataHandler((DataSource)new EncodedDataSource(config, multipartPart.getContentType(), multipartPart.getContent())));
        bodyPart.setHeader("Content-Type", multipartPart.getContentType());
        return bodyPart;
    }

    private static class EncodedDataSource
    implements DataSource {
        private final ChainedHttpConfig config;
        private final String contentType;
        private final Object value;

        private EncodedDataSource(ChainedHttpConfig config, String contentType, Object value) {
            this.config = config;
            this.contentType = contentType != null ? contentType : "text/plain";
            this.value = value;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(EmbeddedEncoder.encode(this.config, this.contentType, this.value));
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Writing is not supported.");
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return null;
        }
    }
}

