/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.Map;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluator;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionEvaluatorDispatcher;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.plugins.baseplugin.conditions.PastEventConditionESQueryBuilder;
import org.apache.unomi.scripting.ScriptExecutor;

public class PastEventConditionEvaluator
implements ConditionEvaluator {
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private ScriptExecutor scriptExecutor;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public boolean eval(Condition condition, Item item, Map<String, Object> context, ConditionEvaluatorDispatcher dispatcher) {
        long count;
        Map parameters = condition.getParameterValues();
        if (parameters.containsKey("generatedPropertyKey")) {
            String key = (String)parameters.get("generatedPropertyKey");
            Profile profile = (Profile)item;
            ArrayList pastEvents = (ArrayList)profile.getSystemProperties().get("pastEvents");
            if (pastEvents != null) {
                Number l = (Number)pastEvents.stream().filter(pastEvent -> pastEvent.get("key").equals(key)).findFirst().map(pastEvent -> pastEvent.get("count")).orElse(0L);
                count = l.longValue();
            } else {
                count = 0L;
            }
        } else {
            count = this.persistenceService.queryCount(PastEventConditionESQueryBuilder.getEventCondition(condition, context, item.getItemId(), this.definitionsService, this.scriptExecutor), "event");
        }
        boolean eventsOccurred = PastEventConditionESQueryBuilder.getStrategyFromOperator((String)condition.getParameter("operator"));
        if (eventsOccurred) {
            int minimumEventCount = parameters.get("minimumEventCount") == null ? 0 : (Integer)parameters.get("minimumEventCount");
            int maximumEventCount = parameters.get("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)parameters.get("maximumEventCount");
            return count > 0L && count >= (long)minimumEventCount && count <= (long)maximumEventCount;
        }
        return count == 0L;
    }
}

