/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.net.URL;
import org.apache.log4j.helpers.LogLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";

    public static URL getResource(String resource, Class clazz) {
        return Loader.getResource(resource);
    }

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            Bundle bundle;
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                LogLog.debug("Trying to find [" + resource + "] using context classloader " + classLoader + ".");
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            if ((bundle = FrameworkUtil.getBundle(Loader.class)) != null) {
                LogLog.debug("Trying to find [" + resource + "] using " + bundle.getSymbolicName() + "/" + bundle.getVersion() + " bundle.");
                url = bundle.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            if ((classLoader = Loader.class.getClassLoader()) != null) {
                LogLog.debug("Trying to find [" + resource + "] using " + classLoader + " class loader.");
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            LogLog.warn(TSTR, t);
        }
        LogLog.debug("Trying to find [" + resource + "] using ClassLoader.getSystemResource().");
        return ClassLoader.getSystemResource(resource);
    }

    public static boolean isJava1() {
        return false;
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        Bundle bundle;
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bundle = FrameworkUtil.getBundle(Loader.class)) != null) {
            try {
                return bundle.loadClass(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Class.forName(clazz);
    }
}

