/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.management.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.config.management.CellarConfigMBean;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CellarConfigMBeanImpl
extends StandardMBean
implements CellarConfigMBean {
    private ClusterManager clusterManager;
    private GroupManager groupManager;
    private ConfigurationAdmin configurationAdmin;
    private EventProducer eventProducer;

    public CellarConfigMBeanImpl() throws NotCompliantMBeanException {
        super(CellarConfigMBean.class);
    }

    @Override
    public List<String> getConfigs(String groupName) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        ArrayList<String> result = new ArrayList<String>();
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        for (String pid : clusterConfigurations.keySet()) {
            result.add(pid);
        }
        return result;
    }

    @Override
    public void delete(String groupName, String pid) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalStateException("Configuration PID " + pid + " is blocked outbound for cluster group " + groupName);
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        if (clusterConfigurations == null) {
            throw new IllegalArgumentException("No configuration found in cluster group " + groupName);
        }
        Properties properties = (Properties)clusterConfigurations.remove(pid);
        ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
        event.setSourceGroup(group);
        event.setSourceNode(this.clusterManager.getNode());
        event.setType(2);
        this.eventProducer.produce((Event)event);
    }

    @Override
    public Map<String, String> listProperties(String groupName, String pid) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        Properties clusterProperties = (Properties)clusterConfigurations.get(pid);
        if (clusterProperties != null) {
            Enumeration<?> propertyNames = clusterProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                String value = (String)clusterProperties.get(key);
                properties.put(key, value);
            }
        }
        return properties;
    }

    @Override
    public void setProperty(String groupName, String pid, String key, String value) throws Exception {
        Properties clusterProperties;
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalStateException("Configuration PID " + pid + " is blocked outbound for cluster group " + groupName);
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        if (clusterConfigurations != null) {
            clusterProperties = (Properties)clusterConfigurations.get(pid);
            if (clusterProperties == null) {
                clusterProperties = new Properties();
            }
        } else {
            throw new IllegalArgumentException("No configuration found in cluster group " + groupName);
        }
        clusterProperties.put(key, value);
        clusterConfigurations.put(pid, clusterProperties);
        ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
        event.setSourceGroup(group);
        event.setSourceNode(this.clusterManager.getNode());
        this.eventProducer.produce((Event)event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void appendProperty(String groupName, String pid, String key, String value) throws Exception {
        Object currentValue;
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalStateException("Configuration PID " + pid + " is blocked outbound for cluster group " + groupName);
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        if (clusterConfigurations == null) throw new IllegalArgumentException("No configuration found in cluster group " + groupName);
        Properties clusterProperties = (Properties)clusterConfigurations.get(pid);
        if (clusterProperties == null) {
            clusterProperties = new Properties();
        }
        if ((currentValue = clusterProperties.get(key)) == null) {
            clusterProperties.put(key, value);
        } else {
            if (!(currentValue instanceof String)) throw new IllegalStateException("Append failed: current value is not a String");
            clusterProperties.put(key, currentValue + value);
        }
        clusterConfigurations.put(pid, clusterProperties);
        ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
        event.setSourceGroup(group);
        event.setSourceNode(this.clusterManager.getNode());
        this.eventProducer.produce((Event)event);
    }

    @Override
    public void deleteProperty(String groupName, String pid, String key) throws Exception {
        Group group = this.groupManager.findGroupByName(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Cluster group " + groupName + " doesn't exist");
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            throw new IllegalStateException("Cluster event producer is OFF");
        }
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (!support.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
            throw new IllegalArgumentException("Configuration PID " + pid + " is blocked outbound for cluster group " + groupName);
        }
        Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
        if (clusterConfigurations != null) {
            Properties clusterDictionary = (Properties)clusterConfigurations.get(pid);
            if (clusterDictionary != null) {
                clusterDictionary.remove(key);
                clusterConfigurations.put(pid, clusterDictionary);
                ClusterConfigurationEvent event = new ClusterConfigurationEvent(pid);
                event.setSourceGroup(group);
                event.setSourceNode(this.clusterManager.getNode());
                this.eventProducer.produce((Event)event);
            }
        } else {
            throw new IllegalArgumentException("No configuration found in cluster group " + groupName);
        }
    }

    @Override
    public String getExcludedProperties() throws Exception {
        Dictionary properties;
        Configuration nodeConfiguration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
        if (nodeConfiguration != null && (properties = nodeConfiguration.getProperties()) != null) {
            return properties.get("config.excluded.properties").toString();
        }
        return null;
    }

    @Override
    public void setExcludedProperties(String excludedProperties) throws Exception {
        Configuration nodeConfiguration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
        if (nodeConfiguration != null) {
            Dictionary properties = nodeConfiguration.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("config.excluded.properties", excludedProperties);
            nodeConfiguration.update(properties);
        }
    }

    @Override
    public void block(String groupName, String pid, boolean whitelist, boolean blacklist, boolean in, boolean out) throws Exception {
        CellarSupport support = new CellarSupport();
        support.setClusterManager(this.clusterManager);
        support.setGroupManager(this.groupManager);
        support.setConfigurationAdmin(this.configurationAdmin);
        if (in) {
            if (whitelist) {
                support.switchListEntry("whitelist", groupName, "config", EventType.INBOUND, pid);
            }
            if (blacklist) {
                support.switchListEntry("blacklist", groupName, "config", EventType.INBOUND, pid);
            }
        }
        if (out) {
            if (whitelist) {
                support.switchListEntry("whitelist", groupName, "config", EventType.OUTBOUND, pid);
            }
            if (blacklist) {
                support.switchListEntry("blacklist", groupName, "config", EventType.OUTBOUND, pid);
            }
        }
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

