/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTorqueDynamicGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRole;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTorqueDynamicGroupRoleRecordMapper
implements RecordMapper<TorqueDynamicGroupRole> {
    private static final long serialVersionUID = 1735909173243L;
    private static Log log = LogFactory.getLog(BaseTorqueDynamicGroupRoleRecordMapper.class);
    private static final String GROUP_ID_EXPRESSION = BaseTorqueDynamicGroupRolePeer.GROUP_ID.getSqlExpression();
    private static final String ROLE_ID_EXPRESSION = BaseTorqueDynamicGroupRolePeer.ROLE_ID.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TorqueDynamicGroupRole> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorqueDynamicGroupRole processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TorqueDynamicGroupRole torqueDynamicGroupRole = new TorqueDynamicGroupRole();
        try {
            torqueDynamicGroupRole.setLoading(true);
            if (criteria == null) {
                torqueDynamicGroupRole.setGroupId(this.getGroupId(resultSet, offset + 1));
                torqueDynamicGroupRole.setRoleId(this.getRoleId(resultSet, offset + 2));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(GROUP_ID_EXPRESSION) && GROUP_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setGroupId(this.getGroupId((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicGroupRole.setGroupId(this.getGroupId(resultSet, totalOffset));
                        }
                        columnsMapped.add(GROUP_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(ROLE_ID_EXPRESSION) && ROLE_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setRoleId(this.getRoleId((ResultSet)res, nextOffset)));
                        } else {
                            torqueDynamicGroupRole.setRoleId(this.getRoleId(resultSet, totalOffset));
                        }
                        columnsMapped.add(ROLE_ID_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(2, true);
                    this.strategy.execute(resultSet, (Object)torqueDynamicGroupRole);
                }
            }
            torqueDynamicGroupRole.setNew(false);
            torqueDynamicGroupRole.setModified(false);
        }
        finally {
            torqueDynamicGroupRole.setLoading(false);
        }
        return torqueDynamicGroupRole;
    }

    protected Integer getGroupId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected Integer getRoleId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

