/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import jakarta.enterprise.context.SessionScoped;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.apache.openejb.junit.CdiScopes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ScopesRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Class<? extends Annotation>[] scopes;
                CdiScopes annotation = (CdiScopes)description.getAnnotation(CdiScopes.class);
                if (annotation == null) {
                    base.evaluate();
                    return;
                }
                WebBeansContext wbc = WebBeansContext.currentInstance();
                HashMap<Class<? extends Annotation>, Object> init = new HashMap<Class<? extends Annotation>, Object>();
                for (Class<? extends Annotation> c : scopes = annotation.value()) {
                    Object o = ScopesRule.this.param(c);
                    if (o != null) {
                        init.put(c, o);
                    }
                    wbc.getContextsService().startContext(c, o);
                }
                try {
                    base.evaluate();
                }
                finally {
                    for (Class<? extends Annotation> c : scopes) {
                        wbc.getContextsService().endContext(c, init.get(c));
                    }
                }
            }
        };
    }

    private Object param(Class<?> c) {
        if (SessionScoped.class == c) {
            return new MockHttpSession();
        }
        return null;
    }
}

