/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.core.rate.limit.TimeWindow;
import io.smallrye.faulttolerance.core.stopwatch.RunningStopwatch;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import java.util.ArrayList;
import java.util.List;

final class NaiveRollingWindow
implements TimeWindow {
    private final RunningStopwatch stopwatch;
    private final int maxInvocations;
    private final long timeWindowInMillis;
    private final long minSpacingInMillis;
    private final List<Long> timestamps = new ArrayList<Long>();

    NaiveRollingWindow(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        this.stopwatch = stopwatch.start();
        this.maxInvocations = maxInvocations;
        this.timeWindowInMillis = timeWindowInMillis;
        this.minSpacingInMillis = minSpacingInMillis;
    }

    @Override
    public synchronized long record() {
        long timeFromPrevious;
        long result;
        long now = this.stopwatch.elapsedTimeInMillis();
        long validity = now - this.timeWindowInMillis;
        this.timestamps.removeIf(it -> it <= validity);
        long l = result = this.timestamps.size() < this.maxInvocations ? 0L : this.timestamps.get(0) - now + this.timeWindowInMillis;
        if (result == 0L && this.minSpacingInMillis != 0L && !this.timestamps.isEmpty() && (timeFromPrevious = now - this.timestamps.get(this.timestamps.size() - 1)) < this.minSpacingInMillis) {
            result = this.minSpacingInMillis - timeFromPrevious;
        }
        this.timestamps.add(now);
        return result;
    }
}

