/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.Future;
import org.apache.cxf.jaxrs.client.WebClient;

public class AsyncInvokerImpl
implements AsyncInvoker {
    private WebClient wc;

    public AsyncInvokerImpl(WebClient wc) {
        this.wc = wc;
    }

    public Future<Response> get() {
        return this.get(Response.class);
    }

    public <T> Future<T> get(Class<T> responseType) {
        return this.method("GET", responseType);
    }

    public <T> Future<T> get(GenericType<T> responseType) {
        return this.method("GET", responseType);
    }

    public <T> Future<T> get(InvocationCallback<T> callback) {
        return this.method("GET", callback);
    }

    public Future<Response> put(Entity<?> entity) {
        return this.put(entity, Response.class);
    }

    public <T> Future<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    public <T> Future<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("PUT", entity, callback);
    }

    public Future<Response> post(Entity<?> entity) {
        return this.post(entity, Response.class);
    }

    public <T> Future<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    public <T> Future<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("POST", entity, callback);
    }

    public Future<Response> delete() {
        return this.delete(Response.class);
    }

    public <T> Future<T> delete(Class<T> responseType) {
        return this.method("DELETE", responseType);
    }

    public <T> Future<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", responseType);
    }

    public <T> Future<T> delete(InvocationCallback<T> callback) {
        return this.method("DELETE", callback);
    }

    public Future<Response> head() {
        return this.method("HEAD");
    }

    public Future<Response> head(InvocationCallback<Response> callback) {
        return this.method("HEAD", callback);
    }

    public Future<Response> options() {
        return this.options(Response.class);
    }

    public <T> Future<T> options(Class<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    public <T> Future<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    public <T> Future<T> options(InvocationCallback<T> callback) {
        return this.method("OPTIONS", callback);
    }

    public Future<Response> trace() {
        return this.trace(Response.class);
    }

    public <T> Future<T> trace(Class<T> responseType) {
        return this.method("TRACE", responseType);
    }

    public <T> Future<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", responseType);
    }

    public <T> Future<T> trace(InvocationCallback<T> callback) {
        return this.method("TRACE", callback);
    }

    public Future<Response> method(String name) {
        return this.method(name, Response.class);
    }

    public <T> Future<T> method(String name, Class<T> responseType) {
        return this.wc.doInvokeAsync(name, null, null, null, responseType, responseType, null);
    }

    public <T> Future<T> method(String name, GenericType<T> responseType) {
        return this.wc.doInvokeAsync(name, null, null, null, responseType.getRawType(), responseType.getType(), null);
    }

    public <T> Future<T> method(String name, InvocationCallback<T> callback) {
        return this.wc.doInvokeAsyncCallback(name, null, null, null, callback);
    }

    public Future<Response> method(String name, Entity<?> entity) {
        return this.method(name, entity, Response.class);
    }

    public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.wc.doInvokeAsync(name, entity, null, null, responseType, responseType, null);
    }

    public <T> Future<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.wc.doInvokeAsync(name, entity, null, null, responseType.getRawType(), responseType.getType(), null);
    }

    public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
        return this.wc.doInvokeAsyncCallback(name, entity, null, null, callback);
    }
}

