/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.SessionSynchronization;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.ResourceEnvRef;
import org.apache.openejb.jee.SessionType;

public class LegacyProcessor
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            ClassLoader classLoader = ejbModule.getClassLoader();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                if (bean.getEjbClass() == null) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(bean.getEjbClass());
                    LegacyProcessor.process(clazz, bean);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return appModule;
    }

    public static void process(Class<?> clazz, EnterpriseBean bean) {
        InjectionTarget target;
        ResourceEnvRef ref;
        if (bean instanceof org.apache.openejb.jee.SessionBean) {
            org.apache.openejb.jee.SessionBean sessionBean = (org.apache.openejb.jee.SessionBean)bean;
            if (sessionBean.getSessionType() == SessionType.STATEFUL && SessionSynchronization.class.isAssignableFrom(clazz)) {
                try {
                    sessionBean.getAfterBegin().add(new LifecycleCallback(clazz.getMethod("afterBegin", new Class[0])));
                    sessionBean.getBeforeCompletion().add(new LifecycleCallback(clazz.getMethod("beforeCompletion", new Class[0])));
                    sessionBean.getAfterCompletion().add(new LifecycleCallback(clazz.getMethod("afterCompletion", Boolean.TYPE)));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (SessionBean.class.isAssignableFrom(clazz)) {
                ref = new ResourceEnvRef("jakarta.ejb.SessionBean/sessionContext", SessionContext.class);
                target = new InjectionTarget();
                target.setInjectionTargetClass(clazz);
                target.setInjectionTargetName("sessionContext");
                ref.getInjectionTarget().add(target);
                sessionBean.getResourceEnvRef().add(ref);
            }
        }
        if (bean instanceof org.apache.openejb.jee.MessageDrivenBean) {
            org.apache.openejb.jee.MessageDrivenBean messageDrivenBean = (org.apache.openejb.jee.MessageDrivenBean)bean;
            if (MessageDrivenBean.class.isAssignableFrom(clazz)) {
                ref = new ResourceEnvRef("jakarta.ejb.MessageDrivenBean/messageDrivenContext", MessageDrivenContext.class);
                target = new InjectionTarget();
                target.setInjectionTargetClass(clazz);
                target.setInjectionTargetName("messageDrivenContext");
                ref.getInjectionTarget().add(target);
                messageDrivenBean.getResourceEnvRef().add(ref);
            }
        }
    }
}

