/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationOverlay;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlayImpl;

public interface MutableAnnotationOverlay
extends AnnotationOverlay {
    public static Builder builder(IndexView index) {
        Objects.requireNonNull(index);
        return new Builder(index);
    }

    public void addAnnotation(Declaration var1, AnnotationInstance var2);

    public void removeAnnotations(Declaration var1, Predicate<AnnotationInstance> var2);

    public List<AnnotationTransformation> freeze();

    public static final class Builder {
        private final IndexView index;
        private boolean compatibleMode;
        private boolean runtimeAnnotationsOnly;
        private boolean inheritedAnnotations;

        Builder(IndexView index) {
            this.index = index;
        }

        public Builder compatibleMode() {
            this.compatibleMode = true;
            return this;
        }

        public Builder runtimeAnnotationsOnly() {
            this.runtimeAnnotationsOnly = true;
            return this;
        }

        public Builder inheritedAnnotations() {
            this.inheritedAnnotations = true;
            return this;
        }

        public MutableAnnotationOverlay build() {
            return new MutableAnnotationOverlayImpl(this.index, this.compatibleMode, this.runtimeAnnotationsOnly, this.inheritedAnnotations);
        }
    }
}

