/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.servers.Server;

public class PathItemImpl
extends ExtensibleImpl<PathItem>
implements PathItem,
ModelImpl {
    private String ref;
    private String summary;
    private String description;
    private Operation get;
    private Operation put;
    private Operation post;
    private Operation delete;
    private Operation options;
    private Operation head;
    private Operation patch;
    private Operation trace;
    private List<Parameter> parameters;
    private List<Server> servers;

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public PathItem summary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Operation getGET() {
        return this.get;
    }

    public void setGET(Operation get) {
        this.get = get;
    }

    public Operation getPUT() {
        return this.put;
    }

    public void setPUT(Operation put) {
        this.put = put;
    }

    public Operation getPOST() {
        return this.post;
    }

    public void setPOST(Operation post) {
        this.post = post;
    }

    public Operation getDELETE() {
        return this.delete;
    }

    public void setDELETE(Operation delete) {
        this.delete = delete;
    }

    public Operation getOPTIONS() {
        return this.options;
    }

    public void setOPTIONS(Operation options) {
        this.options = options;
    }

    public Operation getHEAD() {
        return this.head;
    }

    public void setHEAD(Operation head) {
        this.head = head;
    }

    public Operation getPATCH() {
        return this.patch;
    }

    public void setPATCH(Operation patch) {
        this.patch = patch;
    }

    public Operation getTRACE() {
        return this.trace;
    }

    public void setTRACE(Operation trace) {
        this.trace = trace;
    }

    public Map<PathItem.HttpMethod, Operation> getOperations() {
        LinkedHashMap<PathItem.HttpMethod, Operation> ops = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        this.addOperationToMap(PathItem.HttpMethod.GET, this.get, ops);
        this.addOperationToMap(PathItem.HttpMethod.PUT, this.put, ops);
        this.addOperationToMap(PathItem.HttpMethod.POST, this.post, ops);
        this.addOperationToMap(PathItem.HttpMethod.DELETE, this.delete, ops);
        this.addOperationToMap(PathItem.HttpMethod.OPTIONS, this.options, ops);
        this.addOperationToMap(PathItem.HttpMethod.HEAD, this.head, ops);
        this.addOperationToMap(PathItem.HttpMethod.PATCH, this.patch, ops);
        this.addOperationToMap(PathItem.HttpMethod.TRACE, this.trace, ops);
        return ops;
    }

    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        switch (httpMethod) {
            case GET: {
                this.get = operation;
                break;
            }
            case POST: {
                this.post = operation;
                break;
            }
            case PUT: {
                this.put = operation;
                break;
            }
            case DELETE: {
                this.delete = operation;
                break;
            }
            case PATCH: {
                this.patch = operation;
                break;
            }
            case OPTIONS: {
                this.options = operation;
                break;
            }
            case HEAD: {
                this.head = operation;
                break;
            }
            case TRACE: {
                this.trace = operation;
            }
        }
    }

    public List<Server> getServers() {
        return ModelUtil.unmodifiableList(this.servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = ModelUtil.replace(servers);
    }

    public PathItem addServer(Server server) {
        this.servers = ModelUtil.add(server, this.servers);
        return this;
    }

    public void removeServer(Server server) {
        ModelUtil.remove(this.servers, server);
    }

    public List<Parameter> getParameters() {
        return ModelUtil.unmodifiableList(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = ModelUtil.replace(parameters);
    }

    public PathItem addParameter(Parameter parameter) {
        this.parameters = ModelUtil.add(parameter, this.parameters);
        return this;
    }

    public void removeParameter(Parameter parameter) {
        ModelUtil.remove(this.parameters, parameter);
    }

    private void addOperationToMap(PathItem.HttpMethod method, Operation operation, Map<PathItem.HttpMethod, Operation> operationMap) {
        if (operation != null) {
            operationMap.put(method, operation);
        }
    }
}

