/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.RateLimiter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class RateLimitFilter
extends FilterBase {
    public static final int DEFAULT_BUCKET_DURATION = 60;
    public static final int DEFAULT_BUCKET_REQUESTS = 300;
    public static final boolean DEFAULT_ENFORCE = true;
    public static final boolean DEFAULT_EXPOSE_HEADERS = false;
    public static final String HEADER_RATE_LIMIT_POLICY = "RateLimit-Policy";
    public static final String HEADER_RATE_LIMIT = "RateLimit";
    public static final int DEFAULT_STATUS_CODE = 429;
    public static final String DEFAULT_STATUS_MESSAGE = "Too many requests";
    public static final String RATE_LIMIT_ATTRIBUTE_COUNT = "org.apache.catalina.filters.RateLimitFilter.Count";
    transient RateLimiter rateLimiter;
    private String rateLimitClassName = "org.apache.catalina.util.FastRateLimiter";
    private int bucketRequests = 300;
    private int bucketDuration = 60;
    private boolean enforce = true;
    private int statusCode = 429;
    private String statusMessage = "Too many requests";
    private String filterName;
    private boolean exposeHeaders = false;
    private String policyName = null;
    private final transient Log log = LogFactory.getLog(RateLimitFilter.class);
    private static final StringManager sm = StringManager.getManager(RateLimitFilter.class);

    public void setBucketDuration(int bucketDuration) {
        this.bucketDuration = bucketDuration;
    }

    public void setBucketRequests(int bucketRequests) {
        this.bucketRequests = bucketRequests;
    }

    public void setEnforce(boolean enforce) {
        this.enforce = enforce;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void setRateLimitClassName(String rateLimitClassName) {
        this.rateLimitClassName = rateLimitClassName;
    }

    public void setExposeHeaders(boolean exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String trimmedName;
        super.init(filterConfig);
        try {
            this.rateLimiter = (RateLimiter)Class.forName(this.rateLimitClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ServletException((Throwable)e);
        }
        this.rateLimiter.setDuration(this.bucketDuration);
        this.rateLimiter.setRequests(this.bucketRequests);
        this.rateLimiter.setFilterConfig(filterConfig);
        if (this.policyName != null && !(trimmedName = this.policyName.trim()).isEmpty()) {
            this.rateLimiter.setPolicyName(trimmedName);
        }
        this.filterName = filterConfig.getFilterName();
        this.log.info((Object)sm.getString("rateLimitFilter.initialized", new Object[]{this.filterName, this.bucketRequests, this.bucketDuration, this.rateLimiter.getRequests(), this.rateLimiter.getDuration(), (!this.enforce ? "Not " : "") + "enforcing"}));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String ipAddr = request.getRemoteAddr();
        int reqCount = this.rateLimiter.increment(ipAddr);
        request.setAttribute(RATE_LIMIT_ATTRIBUTE_COUNT, (Object)reqCount);
        if (this.exposeHeaders) {
            ((HttpServletResponse)response).addHeader(HEADER_RATE_LIMIT_POLICY, this.rateLimiter.getPolicy());
            if (this.enforce) {
                ((HttpServletResponse)response).addHeader(HEADER_RATE_LIMIT, this.rateLimiter.getQuota(reqCount));
            }
        }
        if (reqCount > this.rateLimiter.getRequests()) {
            this.log.warn((Object)sm.getString("rateLimitFilter.maxRequestsExceeded", new Object[]{this.filterName, reqCount, ipAddr, this.rateLimiter.getRequests(), this.rateLimiter.getDuration()}));
            if (this.enforce) {
                ((HttpServletResponse)response).sendError(this.statusCode, this.statusMessage);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.rateLimiter.destroy();
        super.destroy();
    }

    @Override
    protected Log getLogger() {
        return this.log;
    }
}

