/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class RangeLocalStep<S>
extends ScalarMapStep<S, S> {
    private final long low;
    private final long high;

    public RangeLocalStep(Traversal.Admin traversal, long low, long high) {
        super(traversal);
        if (low != -1L && high != -1L && low > high) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + ']');
        }
        this.low = low;
        this.high = high;
    }

    public long getLowRange() {
        return this.low;
    }

    public long getHighRange() {
        return this.high;
    }

    @Override
    protected S map(Traverser.Admin<S> traverser) {
        Object start = traverser.get();
        return (S)RangeLocalStep.applyRange(start, this.low, this.high);
    }

    static <S> S applyRange(S start, long low, long high) {
        if (start instanceof Map) {
            return (S)RangeLocalStep.applyRangeMap((Map)start, low, high);
        }
        if (start instanceof Iterable) {
            return (S)RangeLocalStep.applyRangeIterable((Iterable)start, low, high);
        }
        if (start != null && start.getClass().isArray()) {
            return (S)RangeLocalStep.applyRangeIterable(IteratorUtils.asList(start), low, high);
        }
        return start;
    }

    private static Map applyRangeMap(Map map, long low, long high) {
        long capacity = (high != -1L ? high : (long)map.size()) - low;
        LinkedHashMap result = new LinkedHashMap((int)Math.min(capacity, (long)map.size()));
        long c = 0L;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            if (c >= low) {
                if (c >= high && high != -1L) break;
                result.put(entry.getKey(), entry.getValue());
            }
            ++c;
        }
        return result;
    }

    private static Object applyRangeIterable(Iterable<Object> iterable, long low, long high) {
        boolean single;
        boolean bl = high != -1L ? high - low == 1L : (single = false);
        LinkedHashSet<Object> resultCollection = single ? null : (iterable instanceof Set ? new LinkedHashSet<Object>() : new LinkedList());
        Object result = single ? null : resultCollection;
        long c = 0L;
        for (Object item : iterable) {
            if (c >= low) {
                if (c >= high && high != -1L) break;
                if (single) {
                    result = item;
                    break;
                }
                resultCollection.add(item);
            }
            ++c;
        }
        if (null == result) {
            throw FastNoSuchElementException.instance();
        }
        return result;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.low, this.high);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.high) ^ Long.hashCode(this.low);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }
}

