/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.GenericName;

@TitleProperty(name="featureTypeName")
@XmlType(name="MD_FeatureTypeInfo_Type", propOrder={"featureTypeName", "featureInstanceCount"})
@XmlRootElement(name="MD_FeatureTypeInfo")
@UML(identifier="MD_FeatureTypeInfo", specification=Specification.ISO_19115)
public class DefaultFeatureTypeInfo
extends ISOMetadata {
    private static final long serialVersionUID = -4103901642915981422L;
    private GenericName featureTypeName;
    private Integer featureInstanceCount;

    public DefaultFeatureTypeInfo() {
    }

    public DefaultFeatureTypeInfo(GenericName featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public DefaultFeatureTypeInfo(DefaultFeatureTypeInfo object) {
        super(object);
        if (object != null) {
            this.featureTypeName = object.getFeatureTypeName();
            this.featureInstanceCount = object.getFeatureInstanceCount();
        }
    }

    @XmlElement(name="featureTypeName", required=true)
    @UML(identifier="featureTypeName", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public GenericName getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(GenericName newValue) {
        this.checkWritePermission(this.featureTypeName);
        this.featureTypeName = newValue;
    }

    @ValueRange(minimum=1.0)
    @XmlElement(name="featureInstanceCount")
    @UML(identifier="featureInstanceCount", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getFeatureInstanceCount() {
        return this.featureInstanceCount;
    }

    public void setFeatureInstanceCount(Integer newValue) {
        this.checkWritePermission(this.featureInstanceCount);
        if (ImplementationHelper.ensurePositive(DefaultFeatureTypeInfo.class, "featureInstanceCount", true, newValue)) {
            this.featureInstanceCount = newValue;
        }
    }
}

