/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.j2d.ColorModelBuilder;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.image.Visualization;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;

public interface Colorizer
extends Function<Target, Optional<ColorModel>> {
    public static final Colorizer ARGB = target -> Optional.ofNullable(ColorModelFactory.createRGB(target.getSampleModel()));

    public static Colorizer forRange(double lower, double upper, Color ... colors) {
        ArgumentChecks.ensureNonEmpty("colors", colors);
        return Colorizer.forRanges(Map.of(new NumberRange<Double>(Double.class, lower, true, upper, false), colors));
    }

    public static Colorizer forRanges(Map<NumberRange<?>, Color[]> colors) {
        ArrayList list = new ArrayList(colors.size());
        for (Map.Entry<NumberRange<?>, Color[]> entry : colors.entrySet()) {
            NumberRange<?> range = entry.getKey();
            Color[] value = entry.getValue();
            if (value != null) {
                value = (Color[])value.clone();
            }
            list.add(new AbstractMap.SimpleImmutableEntry(range, value));
        }
        List<Map.Entry<NumberRange<?>, Color[]>> entries = List.copyOf(list);
        ColorModelFactory factory = ColorModelFactory.piecewise(entries);
        return target -> {
            if (target instanceof Visualization.Target) {
                ((Visualization.Target)target).rangeColors = entries;
            } else {
                OptionalInt visibleBand = target.getVisibleBand();
                if (!visibleBand.isEmpty()) {
                    SampleModel model = target.getSampleModel();
                    int numBands = model.getNumBands();
                    return Optional.ofNullable(factory.createColorModel(model.getDataType(), numBands, visibleBand.getAsInt()));
                }
            }
            return Optional.empty();
        };
    }

    public static Colorizer forCategories(Function<Category, Color[]> colors) {
        ArgumentChecks.ensureNonNull("colors", colors);
        return target -> {
            if (target instanceof Visualization.Target) {
                ((Visualization.Target)target).categoryColors = colors;
            } else {
                SampleModel model;
                ColorModelBuilder c;
                List ranges;
                int visibleBand = target.getVisibleBand().orElse(-1);
                if (visibleBand >= 0 && visibleBand < (ranges = (List)target.getRanges().orElse(null)).size() && (c = new ColorModelBuilder(colors, null, false)).initialize(model = target.getSampleModel(), (SampleDimension)ranges.get(visibleBand))) {
                    return Optional.ofNullable(c.createColorModel(model.getDataType(), model.getNumBands(), visibleBand));
                }
            }
            return Optional.empty();
        };
    }

    public static Colorizer forInstance(ColorModel colors) {
        ArgumentChecks.ensureNonNull("colors", colors);
        return target -> colors.isCompatibleSampleModel(target.getSampleModel()) ? Optional.of(colors) : Optional.empty();
    }

    @Override
    public Optional<ColorModel> apply(Target var1);

    default public Colorizer orElse(Colorizer alternative) {
        ArgumentChecks.ensureNonNull("alternative", alternative);
        return target -> {
            Optional<ColorModel> result = this.apply(target);
            if (result.isEmpty() && !target.isConsumed()) {
                result = alternative.apply(target);
            }
            return result;
        };
    }

    public static class Target {
        private final SampleModel model;
        private final List<SampleDimension> ranges;
        private final int visibleBand;

        public Target(SampleModel model, List<SampleDimension> ranges, int visibleBand) {
            this.model = Objects.requireNonNull(model);
            this.ranges = ranges != null ? List.copyOf(ranges) : null;
            int numBands = model.getNumBands();
            if (visibleBand < 0) {
                if (numBands == 1) {
                    this.visibleBand = 0;
                    return;
                }
            } else if (visibleBand < numBands) {
                this.visibleBand = visibleBand;
                return;
            }
            this.visibleBand = -1;
        }

        public SampleModel getSampleModel() {
            return this.model;
        }

        public Optional<List<SampleDimension>> getRanges() {
            return Optional.ofNullable(this.ranges);
        }

        public OptionalInt getVisibleBand() {
            return this.visibleBand >= 0 ? OptionalInt.of(this.visibleBand) : OptionalInt.empty();
        }

        boolean isConsumed() {
            return false;
        }
    }
}

