/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;

public class InheritanceData {
    private final InheritanceData parent;
    private final String packageName;
    private final Set<String> methodNames = PlasticInternalUtils.newSet();
    private final Map<String, Boolean> methods = PlasticInternalUtils.newMap();
    private final Set<String> interfaceNames = PlasticInternalUtils.newSet();

    public InheritanceData(String packageName) {
        this(null, packageName);
    }

    private InheritanceData(InheritanceData parent, String packageName) {
        this.parent = parent;
        this.packageName = packageName;
    }

    public boolean isTransformed() {
        return this.parent != null;
    }

    public InheritanceData createChild(String packageName) {
        return new InheritanceData(this, packageName);
    }

    public void addMethod(String name, String desc, boolean samePackageOnly) {
        this.methods.put(InheritanceData.toValue(name, desc), samePackageOnly);
        this.methodNames.add(name);
    }

    public boolean isImplemented(String name, String desc) {
        return this.checkForMethod(InheritanceData.toValue(name, desc), this);
    }

    public boolean isOverride(String name, String desc) {
        return this.checkForMethod(InheritanceData.toValue(name, desc), this.parent);
    }

    private boolean checkForMethod(String value, InheritanceData cursor) {
        String thisPackageName = this.packageName;
        while (cursor != null) {
            if (cursor.methods.containsKey(value)) {
                boolean mustBeInSamePackage = cursor.methods.get(value);
                if (!mustBeInSamePackage) {
                    return true;
                }
                boolean isInSamePackage = thisPackageName.equals(cursor.packageName);
                if (isInSamePackage) {
                    return true;
                }
            }
            cursor = cursor.parent;
        }
        return false;
    }

    public boolean isInterfaceImplemented(String name) {
        InheritanceData cursor = this;
        while (cursor != null) {
            if (cursor.interfaceNames.contains(name)) {
                return true;
            }
            cursor = cursor.parent;
        }
        return false;
    }

    public void addInterface(String name) {
        if (!this.interfaceNames.contains(name)) {
            this.interfaceNames.add(name);
        }
    }

    private static String toValue(String name, String desc) {
        int endOfParameterSpecIdx = desc.indexOf(41);
        return (name + ":" + desc.substring(0, endOfParameterSpecIdx + 1)).intern();
    }

    public Set<String> methodNames() {
        Set<String> result = PlasticInternalUtils.newSet();
        InheritanceData cursor = this;
        while (cursor != null) {
            result.addAll(cursor.methodNames);
            cursor = cursor.parent;
        }
        return result;
    }
}

