/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public final class ContentType {
    private final String baseType;
    private final String subType;
    private final Map<String, String> parameters;
    private static final Pattern PATTERN = Pattern.compile("^(.+)/([^;]+)(;(.+=[^;]+)){0,3}$");

    public ContentType(String contentType) {
        Matcher matcher = PATTERN.matcher(contentType);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Not a parseable content type '%s'.", contentType));
        }
        this.baseType = matcher.group(1);
        this.subType = matcher.group(2);
        this.parameters = ContentType.parseKeyValues(matcher.group(4));
    }

    private ContentType(String baseType, String subType, Map<String, String> parameters) {
        this.baseType = baseType;
        this.subType = subType;
        this.parameters = parameters;
    }

    private static Map<String, String> parseKeyValues(String keyValues) {
        if (keyValues == null) {
            return Collections.emptyMap();
        }
        Map parameters = CollectionFactory.newCaseInsensitiveMap();
        StringTokenizer tk = new StringTokenizer(keyValues, ";");
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            int sep = token.indexOf(61);
            parameters.put(token.substring(0, sep), token.substring(sep + 1));
        }
        return parameters;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ContentType ct = (ContentType)o;
        return this.baseType.equals(ct.baseType) && this.subType.equals(ct.subType) && this.parameters.equals(ct.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.baseType, this.subType, this.parameters);
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getMimeType() {
        return this.baseType + "/" + this.subType;
    }

    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this.parameters);
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public String getParameter(String key) {
        assert (key != null);
        return this.parameters.get(key);
    }

    private String unparse() {
        StringBuilder buffer = new StringBuilder(this.getMimeType());
        for (String parameterName : this.getParameterNames()) {
            buffer.append(';');
            buffer.append(parameterName);
            buffer.append('=');
            buffer.append(this.parameters.get(parameterName));
        }
        return buffer.toString();
    }

    public ContentType withParameter(String key, String value) {
        assert (InternalUtils.isNonBlank((String)key));
        assert (InternalUtils.isNonBlank((String)value));
        Map newParameters = CollectionFactory.newCaseInsensitiveMap();
        newParameters.putAll(this.parameters);
        newParameters.put(key, value);
        return new ContentType(this.baseType, this.subType, newParameters);
    }

    public ContentType withCharset(String charset) {
        return this.withParameter("charset", charset);
    }

    public String toString() {
        return this.unparse();
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }
}

