/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.services.StackTraceElementAnalyzer;

public class TapestryAOPStackFrameAnalyzer
implements StackTraceElementAnalyzer {
    private static final String[] SYNTHETIC_METHOD_PREFIXES = new String[]{"conduit_get_", "conduit_set_", "reject_field_change_", "shim_set_", "shim_get_"};

    @Override
    public String classForFrame(StackTraceElement frame) {
        if (this.omit(frame)) {
            return "omitted-frame";
        }
        return null;
    }

    private boolean omit(StackTraceElement frame) {
        if (frame.getClassName().equals("org.apache.tapestry5.internal.plastic.MethodHandleImpl")) {
            return true;
        }
        if (frame.getMethodName().equals("invoke") && frame.getClassName().contains("$MethodAccess_")) {
            return true;
        }
        if (frame.getMethodName().equals("proceedToAdvisedMethod") && frame.getClassName().contains("$Invocation_")) {
            return true;
        }
        if (frame.getMethodName().equals("invoke") && frame.getClassName().contains("$Shim_")) {
            return true;
        }
        for (String prefix : SYNTHETIC_METHOD_PREFIXES) {
            if (!frame.getMethodName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

