/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.commons.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;

public class FieldTranslatorImpl<T>
implements FieldTranslator<T> {
    private final Field field;
    private final Translator<T> translator;
    private final MessageFormatter formatter;
    private final FormSupport formSupport;

    public FieldTranslatorImpl(Field field, Translator<T> translator, MessageFormatter formatter, FormSupport formSupport) {
        this.field = field;
        this.translator = translator;
        this.formatter = formatter;
        this.formSupport = formSupport;
    }

    @Override
    public T parse(String input) throws ValidationException {
        return this.translator.parseClient(this.field, input, this.formatMessage());
    }

    private String formatMessage() {
        return this.formatter.format(new Object[]{this.field.getLabel()});
    }

    @Override
    public void render(MarkupWriter writer) {
        this.translator.render(this.field, this.formatMessage(), writer, this.formSupport);
    }

    @Override
    public String toClient(T value) {
        return this.translator.toClient(value);
    }

    @Override
    public Class<T> getType() {
        return this.translator.getType();
    }
}

