/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.commons.util.AvailableValues;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.services.Environment;

public class EnvironmentImpl
implements Environment {
    private Map<Class, LinkedList> typeToStack = CollectionFactory.newMap();
    private final OneShotLock lock = new OneShotLock();

    private <T> LinkedList<T> stackFor(Class<T> type) {
        this.lock.check();
        LinkedList result = this.typeToStack.get(type);
        if (result == null) {
            result = CollectionFactory.newLinkedList();
            this.typeToStack.put(type, result);
        }
        return result;
    }

    @Override
    public <T> T peek(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.isEmpty() ? null : (T)stack.getFirst();
    }

    @Override
    public <T> T peekRequired(Class<T> type) {
        T result = this.peek(type);
        if (result == null) {
            List types = CollectionFactory.newList();
            for (Map.Entry<Class, LinkedList> e : this.typeToStack.entrySet()) {
                LinkedList list = e.getValue();
                if (list == null || list.isEmpty()) continue;
                types.add(e.getKey());
            }
            throw new UnknownValueException(String.format("No object of type %s is available from the Environment.", type.getName()), new AvailableValues("Environmentals", (Collection)((Flow)F.flow(this.typeToStack.entrySet()).remove((Predicate)new Predicate<Map.Entry<Class, LinkedList>>(){

                public boolean accept(Map.Entry<Class, LinkedList> element) {
                    return element.getValue().isEmpty();
                }
            })).map((Mapper)new Mapper<Map.Entry<Class, LinkedList>, String>(){

                public String map(Map.Entry<Class, LinkedList> element) {
                    return element.getKey().getName();
                }
            }).toList()));
        }
        return result;
    }

    @Override
    public <T> T pop(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.removeFirst();
    }

    @Override
    public <T> T push(Class<T> type, T instance) {
        LinkedList<T> stack = this.stackFor(type);
        T result = stack.isEmpty() ? null : (T)stack.getFirst();
        stack.addFirst(instance);
        return result;
    }

    public void threadDidCleanup() {
        this.lock.lock();
    }

    @Override
    public void cloak() {
        throw new UnsupportedOperationException("cloak() is no longer available in Tapestry 5.4.");
    }

    @Override
    public void decloak() {
        throw new UnsupportedOperationException("decloak() is no longer available in Tapestry 5.4.");
    }
}

