/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import javax.servlet.http.Cookie;
import org.apache.tapestry5.CookieBuilder;
import org.apache.tapestry5.commons.util.TimeInterval;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.services.CookieSink;
import org.apache.tapestry5.internal.services.CookieSource;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.Cookies;

public class CookiesImpl
implements Cookies {
    private final Request request;
    private final CookieSource cookieSource;
    private final CookieSink cookieSink;
    private final String defaultCookiePath;
    private final int defaultMaxAge;

    public CookiesImpl(Request request, CookieSource cookieSource, CookieSink cookieSink, @Symbol(value="tapestry.context-path") String contextPath, @Symbol(value="tapestry.default-cookie-max-age") @IntermediateType(value=TimeInterval.class) long defaultMaxAge) {
        this.request = request;
        this.cookieSource = cookieSource;
        this.cookieSink = cookieSink;
        this.defaultCookiePath = contextPath + "/";
        this.defaultMaxAge = (int)(defaultMaxAge / 1000L);
    }

    @Override
    public String readCookieValue(String name) {
        Cookie[] cookies = this.cookieSource.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cooky : cookies) {
            if (!cooky.getName().equals(name)) continue;
            return cooky.getValue();
        }
        return null;
    }

    @Override
    public void writeCookieValue(String name, String value) {
        this.getBuilder(name, value).write();
    }

    @Override
    public void writeCookieValue(String name, String value, int maxAge) {
        this.getBuilder(name, value).setMaxAge(maxAge).write();
    }

    @Override
    public void writeCookieValue(String name, String value, String path) {
        this.getBuilder(name, value).setPath(path).write();
    }

    @Override
    public void writeDomainCookieValue(String name, String value, String domain) {
        this.getBuilder(name, value).setDomain(domain).write();
    }

    @Override
    public void writeDomainCookieValue(String name, String value, String domain, int maxAge) {
        this.getBuilder(name, value).setDomain(domain).setMaxAge(maxAge).write();
    }

    @Override
    public void writeCookieValue(String name, String value, String path, String domain) {
        this.getBuilder(name, value).setPath(path).setDomain(domain).write();
    }

    @Override
    public void removeCookieValue(String name) {
        this.getBuilder(name, null).delete();
    }

    @Override
    public CookieBuilder getBuilder(String name, String value) {
        CookieBuilder builder = new CookieBuilder(name, value){

            @Override
            public void write() {
                Cookie cookie = new Cookie(this.name, this.value);
                cookie.setPath(this.path == null ? CookiesImpl.this.defaultCookiePath : this.path);
                if (this.domain != null) {
                    cookie.setDomain(this.domain);
                }
                cookie.setMaxAge(this.maxAge == null ? CookiesImpl.this.defaultMaxAge : this.maxAge);
                cookie.setSecure(this.secure == null ? CookiesImpl.this.request.isSecure() : this.secure.booleanValue());
                cookie.setVersion(this.version);
                if (this.comment != null) {
                    cookie.setComment(this.comment);
                }
                if (this.httpOnly != null) {
                    cookie.setHttpOnly(this.httpOnly.booleanValue());
                }
                CookiesImpl.this.cookieSink.addCookie(cookie);
            }

            @Override
            public void delete() {
                this.setMaxAge(0);
                this.write();
            }
        };
        return builder;
    }
}

