/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import org.apache.tapestry5.commons.Resource;

public class ResourceTransformUtils {
    private static final double NANOS_TO_MILLIS = 1.0E-6;

    public static double nanosToMillis(long nanos) {
        return (double)nanos * 1.0E-6;
    }

    public static long toChecksum(Resource resource) {
        Adler32 checksum = new Adler32();
        byte[] buffer = new byte[1024];
        InputStream is = null;
        try {
            int length;
            is = resource.openStream();
            while ((length = is.read(buffer)) >= 0) {
                checksum.update(buffer, 0, length);
            }
            is.close();
            return checksum.getValue();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

