/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.LocalFileUtils;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class LineageCacheEviction {
    private static long _cachesize = 0L;
    private static long CACHE_LIMIT;
    private static long _startTimestamp;
    protected static final Map<LineageItem, Integer> _removelist;
    private static String _outdir;
    private static TreeSet<LineageCacheEntry> weightedQueue;

    protected static void resetEviction() {
        _cachesize = 0L;
        weightedQueue.clear();
        _outdir = null;
        _removelist.clear();
    }

    protected static void addEntry(LineageCacheEntry entry) {
        if (entry.isNullVal()) {
            return;
        }
        double exectime = (double)entry._computeTime / 1000000.0;
        if (!entry.isMatrixValue() && (exectime >= 10.0 || entry._origItem != null)) {
            entry.setCacheStatus(LineageCacheConfig.LineageCacheStatus.PINNED);
        }
        if (entry.isMatrixValue() || exectime < 10.0) {
            entry.computeScore(_removelist);
            weightedQueue.add(entry);
        }
    }

    protected static void getEntry(LineageCacheEntry entry) {
        if (LineageCacheConfig.isTimeBased() && weightedQueue.remove(entry)) {
            entry.updateTimestamp();
            weightedQueue.add(entry);
        }
        if (LineageCacheConfig.isCostNsize() && weightedQueue.remove(entry)) {
            entry.updateScore(true);
            weightedQueue.add(entry);
        }
    }

    private static void removeEntry(Map<LineageItem, LineageCacheEntry> cache, LineageCacheEntry e, boolean updateSpace) {
        if (cache.remove(e._key) != null && updateSpace) {
            LineageCacheEviction.updateSize(e.getSize(), false);
        }
        if (_removelist.containsKey(e._key)) {
            _removelist.replace(e._key, _removelist.get(e._key) + 1);
        } else {
            _removelist.put(e._key, 1);
        }
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementMemDeletes();
        }
    }

    private static void removeOrSpillEntry(Map<LineageItem, LineageCacheEntry> cache, LineageCacheEntry e, boolean spill) {
        if (e._origItem == null) {
            if (spill) {
                LineageCacheEviction.updateSize(e.getSize(), false);
                LineageCacheEviction.spillToLocalFS(cache, e);
                e.setNullValues();
                e.setCacheStatus(LineageCacheConfig.LineageCacheStatus.SPILLED);
            } else {
                LineageCacheEviction.removeEntry(cache, e, true);
            }
            return;
        }
        if (e._origItem != null && !spill) {
            LineageCacheEviction.updateSize(e.getSize(), false);
            LineageCacheEntry h = cache.get(e._origItem);
            while (h != null) {
                LineageCacheEviction.removeEntry(cache, h, false);
                h = h._nextEntry;
            }
            return;
        }
        e.setCacheStatus(spill ? LineageCacheConfig.LineageCacheStatus.TOSPILL : LineageCacheConfig.LineageCacheStatus.TODELETE);
        boolean write = false;
        LineageCacheEntry tmp = cache.get(e._origItem);
        while (tmp != null) {
            if (tmp.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.TOSPILL && tmp.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.TODELETE) {
                return;
            }
            write |= tmp.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TOSPILL;
            tmp = tmp._nextEntry;
        }
        if (write) {
            LineageCacheEviction.spillToLocalFS(cache, cache.get(e._origItem));
            LineageCacheEviction.updateSize(e.getSize(), false);
            LineageCacheEntry h = cache.get(e._origItem);
            while (h != null) {
                h.setNullValues();
                h.setCacheStatus(LineageCacheConfig.LineageCacheStatus.SPILLED);
                h = h._nextEntry;
            }
            return;
        }
        LineageCacheEviction.updateSize(e.getSize(), false);
        LineageCacheEntry h = cache.get(e._origItem);
        while (h != null) {
            LineageCacheEviction.removeEntry(cache, h, false);
            h = h._nextEntry;
        }
    }

    protected static void setCacheLimit(double fraction) {
        long limit;
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        CACHE_LIMIT = limit = (long)(fraction * (double)maxMem);
    }

    public static long getCacheLimit() {
        return CACHE_LIMIT;
    }

    public static long getAvailableSpace() {
        return CACHE_LIMIT - _cachesize;
    }

    protected static void updateSize(long space, boolean addspace) {
        _cachesize = addspace ? (_cachesize += space) : (_cachesize -= space);
    }

    public static void removeAll(Map<LineageItem, LineageCacheEntry> cache) {
        while (!weightedQueue.isEmpty()) {
            LineageCacheEntry e = weightedQueue.pollFirst();
            if (e == null) continue;
            LineageCacheEviction.removeOrSpillEntry(cache, e, false);
        }
    }

    protected static boolean isBelowThreshold(long spaceNeeded) {
        return spaceNeeded + _cachesize <= CACHE_LIMIT;
    }

    protected static void makeSpace(Map<LineageItem, LineageCacheEntry> cache, long spaceNeeded) {
        LineageCacheEntry e;
        while (spaceNeeded + _cachesize > CACHE_LIMIT && (e = weightedQueue.pollFirst()) != null) {
            if (!LineageCacheConfig.isSetSpill()) {
                LineageCacheEviction.removeOrSpillEntry(cache, e, false);
                continue;
            }
            if (!e.getCacheStatus().canEvict()) continue;
            if (!e.isMatrixValue()) {
                LineageCacheEviction.removeOrSpillEntry(cache, e, false);
                continue;
            }
            double spilltime = LineageCacheEviction.getDiskSpillEstimate(e) * 1000.0;
            double exectime = (double)e._computeTime / 1000000.0;
            if (spilltime < 10.0) {
                LineageCacheEviction.removeOrSpillEntry(cache, e, exectime >= 10.0);
                continue;
            }
            LineageCacheEviction.removeOrSpillEntry(cache, e, exectime > spilltime);
        }
    }

    protected static void setStartTimestamp() {
        _startTimestamp = System.currentTimeMillis();
    }

    protected static long getStartTimestamp() {
        return _startTimestamp;
    }

    private static double getDiskSpillEstimate(LineageCacheEntry e) {
        if (!e.isMatrixValue() || e.isNullVal()) {
            return 0.0;
        }
        double size = LineageCacheEviction.getDiskSizeEstimate(e);
        double loadtime = LineageCacheEviction.isSparse(e) ? size / LineageCacheConfig.FSREAD_SPARSE : size / LineageCacheConfig.FSREAD_DENSE;
        double writetime = LineageCacheEviction.isSparse(e) ? size / LineageCacheConfig.FSWRITE_SPARSE : size / LineageCacheConfig.FSWRITE_DENSE;
        return loadtime + writetime;
    }

    private static double getDiskSizeEstimate(LineageCacheEntry e) {
        if (!e.isMatrixValue() || e.isNullVal()) {
            return 0.0;
        }
        MatrixBlock mb = e.getMBValue();
        long r = mb.getNumRows();
        long c = mb.getNumColumns();
        long nnz = mb.getNonZeros();
        double s = OptimizerUtils.getSparsity(r, c, nnz);
        double disksize = (double)MatrixBlock.estimateSizeOnDisk(r, c, (long)(s * (double)r * (double)c)) / 1048576.0;
        return disksize;
    }

    private static void adjustReadWriteSpeed(LineageCacheEntry e, double IOtime, boolean read) {
        double size = LineageCacheEviction.getDiskSizeEstimate(e);
        if (!e.isMatrixValue() || size < 2.0) {
            return;
        }
        double newIOSpeed = size / IOtime;
        if (read) {
            if (LineageCacheEviction.isSparse(e)) {
                LineageCacheConfig.FSREAD_SPARSE = (LineageCacheConfig.FSREAD_SPARSE + newIOSpeed) / 2.0;
            } else {
                LineageCacheConfig.FSREAD_DENSE = (LineageCacheConfig.FSREAD_DENSE + newIOSpeed) / 2.0;
            }
        } else if (LineageCacheEviction.isSparse(e)) {
            LineageCacheConfig.FSWRITE_SPARSE = (LineageCacheConfig.FSWRITE_SPARSE + newIOSpeed) / 2.0;
        } else {
            LineageCacheConfig.FSWRITE_DENSE = (LineageCacheConfig.FSWRITE_DENSE + newIOSpeed) / 2.0;
        }
    }

    private static boolean isSparse(LineageCacheEntry e) {
        if (!e.isMatrixValue() || e.isNullVal()) {
            return false;
        }
        return e.getMBValue().isInSparseFormat();
    }

    private static void spillToLocalFS(Map<LineageItem, LineageCacheEntry> cache, LineageCacheEntry entry) {
        LineageCacheEntry tmp;
        if (!entry.isMatrixValue()) {
            throw new DMLRuntimeException("Spilling scalar objects to disk is not allowd. Key: " + entry._key);
        }
        if (entry.isNullVal()) {
            throw new DMLRuntimeException("Cannot spill null value to disk. Key: " + entry._key);
        }
        if (entry._origItem == null && entry.getOutfile() != null) {
            return;
        }
        if (entry._origItem != null && (tmp = cache.get(entry._origItem)).getOutfile() != null) {
            return;
        }
        long t0 = System.nanoTime();
        if (_outdir == null) {
            _outdir = LocalFileUtils.getUniqueWorkingDir("lineage");
            LocalFileUtils.createLocalFileIfNotExist(_outdir);
        }
        String outfile = _outdir + "/" + entry._key.getId();
        try {
            LocalFileUtils.writeMatrixBlockToLocal(outfile, entry.getMBValue());
        }
        catch (IOException e) {
            throw new DMLRuntimeException("Write to " + outfile + " failed.", e);
        }
        long t1 = System.nanoTime();
        LineageCacheEviction.adjustReadWriteSpeed(entry, (double)(t1 - t0) / 1.0E9, false);
        if (entry._origItem == null) {
            entry.setOutfile(outfile);
        } else {
            LineageCacheEntry h = cache.get(entry._origItem);
            while (h != null) {
                h.setOutfile(outfile);
                h = h._nextEntry;
            }
        }
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementFSWriteTime(t1 - t0);
            LineageCacheStatistics.incrementFSWrites();
        }
    }

    protected static LineageCacheEntry readFromLocalFS(Map<LineageItem, LineageCacheEntry> cache, LineageItem key) {
        if (cache.get(key) == null) {
            throw new DMLRuntimeException("Spilled item should present in cache. Key: " + key);
        }
        LineageCacheEntry e = cache.get(key);
        long t0 = System.nanoTime();
        MatrixBlock mb = null;
        try {
            mb = LocalFileUtils.readMatrixBlockFromLocal(e.getOutfile());
        }
        catch (IOException exp) {
            throw new DMLRuntimeException("Read from " + e.getOutfile() + " failed.", exp);
        }
        long t1 = System.nanoTime();
        e.setValue(mb);
        if (e._origItem != null) {
            LineageCacheEntry h = cache.get(e._origItem);
            while (h != null) {
                h.setValue(mb);
                h = h._nextEntry;
            }
        }
        LineageCacheEviction.updateSize(e.getSize(), true);
        LineageCacheEviction.adjustReadWriteSpeed(e, (double)(t1 - t0) / 1.0E9, true);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementFSReadTime(t1 - t0);
            LineageCacheStatistics.incrementFSHits();
        }
        return cache.get(key);
    }

    static {
        _startTimestamp = 0L;
        _removelist = new HashMap<LineageItem, Integer>();
        _outdir = null;
        weightedQueue = new TreeSet<LineageCacheEntry>(LineageCacheConfig.LineageCacheComparator);
    }
}

