/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.TensorWriter;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class TensorWriterTextCell
extends TensorWriter {
    @Override
    public void writeTensorToHDFS(TensorBlock src, String fname, int blen) throws IOException {
        int[] dims = src.getDims();
        if (src.getNumDims() != dims.length) {
            throw new IOException("Tensor number of dimensions mismatch with metadata: " + src.getNumDims() + " vs " + dims.length);
        }
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] == src.getDim(i)) continue;
            throw new IOException("Tensor dimension (" + (i + 1) + ") mismatch with metadata: " + src.getDim(i) + " vs " + dims[i]);
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        this.writeTextCellTensorToHDFS(path, fs, src);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeTextCellTensorToHDFS(Path path, FileSystem fs, TensorBlock src) throws IOException {
        TensorWriterTextCell.writeTextCellTensorToFile(path, fs, src, 0, src.getNumRows());
    }

    protected static void writeTextCellTensorToFile(Path path, FileSystem fs, TensorBlock src, int rl, int ru) throws IOException {
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            int[] dims = src.getDims();
            StringBuilder sb = new StringBuilder();
            int[] ix = new int[dims.length];
            ix[0] = rl;
            for (long i = 0L; i < src.getLength() / (long)src.getNumRows() * (long)(ru - rl); ++i) {
                boolean skip;
                Types.ValueType vt;
                Object obj = src.get(ix);
                Types.ValueType valueType = vt = src.isBasic() ? src.getValueType() : src.getSchema()[ix[1]];
                if (vt == Types.ValueType.STRING) {
                    skip = obj == null || ((String)obj).isEmpty();
                } else {
                    boolean bl = skip = UtilFunctions.objectToDouble(vt, obj) == 0.0;
                }
                if (!skip) {
                    for (int j : ix) {
                        sb.append(j + 1).append(' ');
                    }
                    sb.append(src.get(ix)).append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                }
                src.getNextIndexes(ix);
            }
            if (src.isEmpty(false)) {
                for (int i = 0; i < dims.length; ++i) {
                    sb.append(0).append(' ');
                }
                sb.append(0).append('\n');
                br.write(sb.toString());
            }
        }
    }
}

