/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.AggregateBinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysds.runtime.matrix.data.TripleIndexes;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import scala.Tuple2;

public class RmmSPInstruction
extends AggregateBinarySPInstruction {
    private RmmSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.RMM, op, in1, in2, out, opcode, istr);
    }

    public static RmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if ("rmm".equals(opcode)) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            return new RmmSPInstruction(null, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("RmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        DataCharacteristics mc1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mc2 = sec.getDataCharacteristics(this.input2.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName());
        DataCharacteristics mcOut = this.updateBinaryMMOutputDataCharacteristics(sec, true);
        JavaPairRDD<TripleIndexes, MatrixBlock> tmp1 = in1.flatMapToPair(new RmmReplicateFunction(mc2.getCols(), mc2.getBlocksize(), true));
        JavaPairRDD<TripleIndexes, MatrixBlock> tmp2 = in2.flatMapToPair(new RmmReplicateFunction(mc1.getRows(), mc1.getBlocksize(), false));
        int numPartJoin = Math.max(RmmSPInstruction.getNumJoinPartitions(mc1, mc2), SparkExecutionContext.getDefaultParallelism(true));
        int numPartOut = SparkUtils.getNumPreferredPartitions(mcOut);
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = tmp1.join(tmp2, numPartJoin).mapToPair(new RmmMultiplyFunction());
        out = RDDAggregateUtils.sumByKeyStable(out, numPartOut, false);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
    }

    private static int getNumJoinPartitions(DataCharacteristics mc1, DataCharacteristics mc2) {
        if (!mc1.dimsKnown() || !mc2.dimsKnown()) {
            SparkExecutionContext.getDefaultParallelism(true);
        }
        double hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
        double matrix1PSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(mc1) * (long)Math.ceil((double)mc2.getCols() / (double)mc2.getBlocksize());
        double matrix2PSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(mc2) * (long)Math.ceil((double)mc1.getRows() / (double)mc1.getBlocksize());
        return (int)Math.max(Math.ceil((matrix1PSize + matrix2PSize) / hdfsBlockSize), 1.0);
    }

    private static class RmmMultiplyFunction
    implements PairFunction<Tuple2<TripleIndexes, Tuple2<MatrixBlock, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -5772410117511730911L;
        private AggregateBinaryOperator _op = null;

        public RmmMultiplyFunction() {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            this._op = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<TripleIndexes, Tuple2<MatrixBlock, MatrixBlock>> arg0) throws Exception {
            TripleIndexes ixIn = (TripleIndexes)arg0._1();
            MatrixIndexes ixOut = new MatrixIndexes(ixIn.getFirstIndex(), ixIn.getSecondIndex());
            MatrixBlock blkIn1 = (MatrixBlock)((Tuple2)arg0._2())._1();
            MatrixBlock blkIn2 = (MatrixBlock)((Tuple2)arg0._2())._2();
            MatrixBlock blkOut = OperationsOnMatrixValues.matMult(blkIn1, blkIn2, new MatrixBlock(), this._op);
            return new Tuple2((Object)ixOut, (Object)blkOut);
        }
    }

    private static class RmmReplicateFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, TripleIndexes, MatrixBlock> {
        private static final long serialVersionUID = 3577072668341033932L;
        private long _len = -1L;
        private long _blen = -1L;
        private boolean _left = false;

        public RmmReplicateFunction(long len, long blen, boolean left) {
            this._len = len;
            this._blen = blen;
            this._left = left;
        }

        public Iterator<Tuple2<TripleIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            LinkedList<Tuple2> ret = new LinkedList<Tuple2>();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            long numBlocks = (long)Math.ceil((double)this._len / (double)this._blen);
            if (this._left) {
                long i = ixIn.getRowIndex();
                long k = ixIn.getColumnIndex();
                for (long j = 1L; j <= numBlocks; ++j) {
                    TripleIndexes tmptix = new TripleIndexes(i, j, k);
                    ret.add(new Tuple2((Object)tmptix, (Object)blkIn));
                }
            } else {
                long k = ixIn.getRowIndex();
                long j = ixIn.getColumnIndex();
                for (long i = 1L; i <= numBlocks; ++i) {
                    TripleIndexes tmptix = new TripleIndexes(i, j, k);
                    ret.add(new Tuple2((Object)tmptix, (Object)blkIn));
                }
            }
            return ret.iterator();
        }
    }
}

