/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.text.DecimalFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ValueTrimFormat
implements Comparable<ValueTrimFormat> {
    private final int colIndex;
    private Object actualValue;
    public char S;
    private char[] N;
    private String NString;
    private Types.ValueType valueType;

    public ValueTrimFormat(int actualValue) {
        this(-1, Types.ValueType.INT32, actualValue);
    }

    public ValueTrimFormat(String actualValue) {
        this.valueType = Types.ValueType.STRING;
        this.actualValue = actualValue;
        this.colIndex = -1;
    }

    public ValueTrimFormat(int colIndex, Types.ValueType vt, Object o) {
        this.valueType = vt;
        this.colIndex = colIndex;
        this.actualValue = o;
        if (vt.isNumeric()) {
            double value = UtilFunctions.getDouble(o);
            DecimalFormat decimalFormat = new DecimalFormat("0.000000000000000000000000000000");
            String stringValue = decimalFormat.format(value);
            if (value == 0.0) {
                this.S = (char)43;
                this.N = new char[]{'0'};
            } else {
                this.S = (char)(value < 0.0 ? 45 : 43);
                if ((o instanceof Long || o instanceof Integer) && stringValue.contains(".")) {
                    stringValue = stringValue.substring(0, stringValue.indexOf("."));
                }
                this.numberTrimFormat(stringValue);
            }
            StringBuilder s = new StringBuilder();
            char[] cArray = this.N;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                s.append(c);
            }
            this.NString = s.toString();
        } else if (vt != Types.ValueType.STRING && vt != Types.ValueType.BOOLEAN) {
            throw new RuntimeException("Don't support  value type format!");
        }
    }

    private void numberTrimFormat(String stringValue) {
        String subValue;
        if (stringValue.charAt(0) == '+' || stringValue.charAt(0) == '-') {
            stringValue = stringValue.substring(1);
        }
        int length = stringValue.length();
        int firstNZ = -1;
        int lastNZ = -1;
        for (int i = 0; i < length; ++i) {
            char fChar = stringValue.charAt(i);
            char lChar = stringValue.charAt(length - i - 1);
            if (Character.isDigit(fChar) && fChar != '0' && firstNZ == -1) {
                firstNZ = i;
            }
            if (Character.isDigit(lChar) && lChar != '0' && lastNZ == -1) {
                lastNZ = length - i;
            }
            if (firstNZ > 0 && lastNZ > 0) break;
        }
        int dotLength = (subValue = stringValue.substring(firstNZ, lastNZ)).contains(".") ? 1 : 0;
        this.N = new char[lastNZ - firstNZ - dotLength];
        int index = 0;
        char[] cArray = subValue.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '.') continue;
            this.N[index++] = c.charValue();
        }
    }

    public double getDoubleActualValue() {
        return UtilFunctions.getDouble(this.actualValue);
    }

    public ValueTrimFormat getACopy() {
        ValueTrimFormat copy = null;
        if (this.valueType.isNumeric()) {
            copy = new ValueTrimFormat(this.colIndex, this.valueType, this.getDoubleActualValue());
            copy.S = this.S;
            copy.N = this.N;
        } else {
            copy = new ValueTrimFormat(this.colIndex, this.valueType, this.actualValue);
        }
        return copy;
    }

    public boolean isNotSet() {
        if (this.valueType == Types.ValueType.STRING) {
            return this.actualValue == null || ((String)this.actualValue).length() == 0;
        }
        if (this.valueType.isNumeric()) {
            return this.getDoubleActualValue() == 0.0;
        }
        if (this.valueType == Types.ValueType.BOOLEAN) {
            return this.actualValue == null || (Boolean)this.actualValue == false;
        }
        return true;
    }

    public void setNoSet() {
        if (this.valueType == Types.ValueType.STRING) {
            this.actualValue = "";
        } else if (this.valueType.isNumeric()) {
            this.actualValue = 0.0;
            this.S = (char)43;
            this.N = new char[]{'0'};
            this.NString = null;
        } else if (this.valueType == Types.ValueType.BOOLEAN) {
            this.actualValue = null;
        }
    }

    public String getStringOfActualValue() {
        return UtilFunctions.objectToString(this.actualValue);
    }

    public boolean isEqual(ValueTrimFormat vtf) {
        if (vtf.getValueType() != this.getValueType()) {
            return false;
        }
        if (vtf.getValueType() == Types.ValueType.FP32) {
            return ((Float)this.actualValue).compareTo((Float)vtf.actualValue) == 0;
        }
        return UtilFunctions.compareTo(this.valueType, this.actualValue, vtf.actualValue) == 0;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    private static int getLength(ValueTrimFormat vtf) {
        Types.ValueType vt = vtf.valueType;
        int len = -1;
        if (vt == Types.ValueType.STRING) {
            len = vtf.getStringOfActualValue().length();
        } else if (vt == Types.ValueType.BOOLEAN) {
            len = 1;
        }
        return len;
    }

    @Override
    public int compareTo(ValueTrimFormat vtf) {
        Types.ValueType vt = vtf.valueType;
        if (vt.isNumeric() && this.valueType.isNumeric()) {
            return ValueTrimFormat.compareNumericVTF(vtf, this);
        }
        if (vt.isNumeric() && this.valueType == Types.ValueType.STRING) {
            return -1;
        }
        if (vt == Types.ValueType.STRING && this.valueType.isNumeric()) {
            try {
                Double d = Double.parseDouble(vtf.getStringOfActualValue());
                ValueTrimFormat vtfs = new ValueTrimFormat(-1, Types.ValueType.FP64, d);
                return ValueTrimFormat.compareNumericVTF(vtfs, this);
            }
            catch (Exception exception) {
                return 1;
            }
        }
        return Integer.compare(ValueTrimFormat.getLength(vtf), ValueTrimFormat.getLength(this));
    }

    private static int compareNumericVTF(ValueTrimFormat vtf1, ValueTrimFormat vtf2) {
        int s2;
        double dv2;
        double dv1 = vtf1.getDoubleActualValue();
        int vc = Double.compare(dv1, dv2 = vtf2.getDoubleActualValue());
        if (vc == 0) {
            return 0;
        }
        int s1 = dv1 >= 0.0 ? 0 : 1;
        int nc = Integer.compare(vtf1.N.length + s1, vtf2.N.length + (s2 = dv2 >= 0.0 ? 0 : 1));
        if (nc == 0) {
            return Double.compare(Math.abs(dv1), Math.abs(dv2));
        }
        return nc;
    }

    public String getNString() {
        return this.NString;
    }

    public Types.ValueType getValueType() {
        return this.valueType;
    }
}

