/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import org.apache.avro.ipc.trace.SingletonTestingTracePlugin;
import org.apache.avro.ipc.trace.TracePlugin;
import org.apache.avro.ipc.trace.TracePluginConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTraceSingletons {
    @Before
    public void clearSingleton() throws Exception {
        SingletonTestingTracePlugin.clearSingletonInfo();
    }

    @Test
    public void testNormalConfiguration() throws IOException {
        TracePluginConfiguration conf = new TracePluginConfiguration();
        SingletonTestingTracePlugin.configureSingleton((TracePluginConfiguration)conf);
        TracePlugin plugin = SingletonTestingTracePlugin.getSingleton();
        Assert.assertEquals((Object)plugin.config, (Object)conf);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidDoubleConfiguration() throws IOException {
        TracePluginConfiguration conf1 = new TracePluginConfiguration();
        TracePluginConfiguration conf2 = new TracePluginConfiguration();
        conf2.clientPort = 3333;
        SingletonTestingTracePlugin.configureSingleton((TracePluginConfiguration)conf1);
        TracePlugin plugin = SingletonTestingTracePlugin.getSingleton();
        SingletonTestingTracePlugin.configureSingleton((TracePluginConfiguration)conf2);
    }

    @Test
    public void testValidDoubleConfiguration() throws IOException {
        TracePluginConfiguration conf1 = new TracePluginConfiguration();
        TracePluginConfiguration conf2 = new TracePluginConfiguration();
        SingletonTestingTracePlugin.configureSingleton((TracePluginConfiguration)conf1);
        TracePlugin plugin = SingletonTestingTracePlugin.getSingleton();
        try {
            SingletonTestingTracePlugin.configureSingleton((TracePluginConfiguration)conf2);
        }
        catch (RuntimeException e) {
            throw new AssertionError((Object)"Valid double configuration threw error.");
        }
    }

    @Test(expected=RuntimeException.class)
    public void testNoConfiguration() throws IOException {
        TracePlugin plugin = SingletonTestingTracePlugin.getSingleton();
    }
}

