/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.client.api.AMRMClient;

public class DMLAppMasterStatusReporter
extends Thread {
    public static final long DEFAULT_REPORT_INTERVAL = 5000L;
    private static final Log LOG = LogFactory.getLog(DMLAppMasterStatusReporter.class);
    private AMRMClient<AMRMClient.ContainerRequest> _rmClient;
    private long _interval;
    private volatile boolean _stop;

    public DMLAppMasterStatusReporter(AMRMClient<AMRMClient.ContainerRequest> rmClient, long interval) {
        this._rmClient = rmClient;
        this._interval = interval > 0L ? interval : 5000L;
        this._stop = false;
    }

    public void stopStatusReporter() {
        this._stop = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this._stop && !Thread.currentThread().isInterrupted()) {
            try {
                this._rmClient.allocate(0.0f);
                Thread.sleep(this._interval);
            }
            catch (InterruptedException ex) {
                LOG.warn("Status reporter interrupted with stop=" + this._stop);
            }
            catch (Exception ex) {
                LOG.error("Failed to report status to ResourceManager.", ex);
            }
        }
    }
}

