/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.aot.AotDetector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.aot.DisabledInAotMode;

class DisabledInAotModeCondition
implements ExecutionCondition {
    DisabledInAotModeCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        boolean aotEnabled = AotDetector.useGeneratedArtifacts();
        if (aotEnabled) {
            AnnotatedElement element = (AnnotatedElement)context.getElement().orElseThrow(() -> new IllegalStateException("No AnnotatedElement"));
            String customReason = DisabledInAotModeCondition.findMergedAnnotation(element, DisabledInAotMode.class).map(DisabledInAotMode::value).orElse(null);
            return ConditionEvaluationResult.disabled((String)"Disabled in Spring AOT mode", (String)customReason);
        }
        return ConditionEvaluationResult.enabled((String)"Spring AOT mode is not enabled");
    }

    private static <A extends Annotation> Optional<A> findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, annotationType));
    }
}

