/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import java.util.Iterator;

public final class AlertSet
implements Iterable<Alert> {
    public static final AlertSet EMPTY = new AlertSet(ImmutableSet.<Alert>of());
    private final ImmutableSet<Alert> alerts;

    AlertSet(Iterable<Alert> alerts) {
        this.alerts = ImmutableSet.copyOf(alerts);
    }

    public int size() {
        return this.alerts.size();
    }

    public boolean isEmpty() {
        return this.alerts.isEmpty();
    }

    @Override
    public Iterator<Alert> iterator() {
        return this.alerts.iterator();
    }

    public boolean hasErrors(AlertPolicy policy) {
        for (Alert alert : this.alerts) {
            if (policy.getSeverity(alert) != Alert.Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof AlertSet && this.equals((AlertSet)that);
    }

    public boolean equals(AlertSet that) {
        return Iterables.elementsEqual(this, that);
    }

    public int hashCode() {
        return Objects.hashCode(this.alerts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertSet(");
        Iterator<Alert> it = this.iterator();
        while (it.hasNext()) {
            Alert alert = it.next();
            sb.append(alert.getClass().getCanonicalName());
            sb.append("(");
            sb.append(alert.toString());
            sb.append(")");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

