/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.handler.codec.http3;

import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelPromise;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3CodecUtils;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3ErrorCode;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3Exception;
import org.apache.storm.shade.io.netty.util.ReferenceCountUtil;
import org.apache.storm.shade.io.netty.util.internal.StringUtil;
import org.jetbrains.annotations.Nullable;

final class Http3FrameValidationUtils {
    private Http3FrameValidationUtils() {
    }

    private static <T> T cast(Object msg) {
        return (T)msg;
    }

    private static <T> boolean isValid(Class<T> frameType, Object msg) {
        return frameType.isInstance(msg);
    }

    @Nullable
    static <T> T validateFrameWritten(Class<T> expectedFrameType, Object msg) {
        if (Http3FrameValidationUtils.isValid(expectedFrameType, msg)) {
            return Http3FrameValidationUtils.cast(msg);
        }
        return null;
    }

    @Nullable
    static <T> T validateFrameRead(Class<T> expectedFrameType, Object msg) {
        if (Http3FrameValidationUtils.isValid(expectedFrameType, msg)) {
            return Http3FrameValidationUtils.cast(msg);
        }
        return null;
    }

    static void frameTypeUnexpected(ChannelPromise promise, Object frame) {
        String type = StringUtil.simpleClassName(frame);
        ReferenceCountUtil.release(frame);
        promise.setFailure(new Http3Exception(Http3ErrorCode.H3_FRAME_UNEXPECTED, "Frame of type " + type + " unexpected"));
    }

    static void frameTypeUnexpected(ChannelHandlerContext ctx, Object frame) {
        ReferenceCountUtil.release(frame);
        Http3CodecUtils.connectionError(ctx, Http3ErrorCode.H3_FRAME_UNEXPECTED, "Frame type unexpected", true);
    }
}

