/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.graph;

import java.util.Set;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.Subgraph;
import org.apache.storm.shade.org.jgrapht.util.ArrayUnenforcedSet;

public class DirectedSubgraph<V, E>
extends Subgraph<V, E, DirectedGraph<V, E>>
implements DirectedGraph<V, E> {
    private static final long serialVersionUID = 3616445700507054133L;

    public DirectedSubgraph(DirectedGraph<V, E> base, Set<V> vertexSubset, Set<E> edgeSubset) {
        super(base, vertexSubset, edgeSubset);
    }

    @Override
    public int inDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        int degree = 0;
        for (Object e : ((DirectedGraph)this.getBase()).incomingEdgesOf(vertex)) {
            if (!this.containsEdge(e)) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        ArrayUnenforcedSet edges = new ArrayUnenforcedSet();
        for (Object e : ((DirectedGraph)this.getBase()).incomingEdgesOf(vertex)) {
            if (!this.containsEdge(e)) continue;
            edges.add(e);
        }
        return edges;
    }

    @Override
    public int outDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        int degree = 0;
        for (Object e : ((DirectedGraph)this.getBase()).outgoingEdgesOf(vertex)) {
            if (!this.containsEdge(e)) continue;
            ++degree;
        }
        return degree;
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        ArrayUnenforcedSet edges = new ArrayUnenforcedSet();
        for (Object e : ((DirectedGraph)this.getBase()).outgoingEdgesOf(vertex)) {
            if (!this.containsEdge(e)) continue;
            edges.add(e);
        }
        return edges;
    }
}

