/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.grouping.PartialKeyGrouping;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringStyle;
import org.apache.storm.topology.BaseConfigurationDeclarer;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.InputDeclarer;
import org.apache.storm.topology.SpoutDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.trident.spout.BatchSpoutExecutor;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.spout.ICommitterTridentSpout;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.spout.RichSpoutBatchTriggerer;
import org.apache.storm.trident.spout.TridentSpoutCoordinator;
import org.apache.storm.trident.spout.TridentSpoutExecutor;
import org.apache.storm.trident.topology.ITridentBatchBolt;
import org.apache.storm.trident.topology.MasterBatchCoordinator;
import org.apache.storm.trident.topology.TridentBoltExecutor;
import org.apache.storm.tuple.Fields;

public class TridentTopologyBuilder {
    static final String SPOUT_COORD_PREFIX = "$spoutcoord-";
    Map<GlobalStreamId, String> batchIds = new HashMap<GlobalStreamId, String>();
    Map<String, TransactionalSpoutComponent> spouts = new HashMap<String, TransactionalSpoutComponent>();
    Map<String, SpoutComponent> batchPerTupleSpouts = new HashMap<String, SpoutComponent>();
    Map<String, Component> bolts = new HashMap<String, Component>();

    public static String spoutCoordinator(String spoutId) {
        return SPOUT_COORD_PREFIX + spoutId;
    }

    public static String spoutIdFromCoordinatorId(String coordId) {
        return coordId.substring(SPOUT_COORD_PREFIX.length());
    }

    public SpoutDeclarer setBatchPerTupleSpout(String id, String streamName, IRichSpout spout, Integer parallelism, String batchGroup) {
        HashMap<String, String> batchGroups = new HashMap<String, String>();
        batchGroups.put(streamName, batchGroup);
        this.markBatchGroups(id, batchGroups);
        SpoutComponent c = new SpoutComponent(spout, streamName, parallelism, batchGroup);
        this.batchPerTupleSpouts.put(id, c);
        return new SpoutDeclarerImpl(c);
    }

    public SpoutDeclarer setSpout(String id, String streamName, String txStateId, IBatchSpout spout, Integer parallelism, String batchGroup) {
        return this.setSpout(id, streamName, txStateId, new BatchSpoutExecutor(spout), parallelism, batchGroup);
    }

    public SpoutDeclarer setSpout(String id, String streamName, String txStateId, ITridentSpout spout, Integer parallelism, String batchGroup) {
        HashMap<String, String> batchGroups = new HashMap<String, String>();
        batchGroups.put(streamName, batchGroup);
        this.markBatchGroups(id, batchGroups);
        TransactionalSpoutComponent c = new TransactionalSpoutComponent(spout, streamName, parallelism, txStateId, batchGroup);
        this.spouts.put(id, c);
        return new SpoutDeclarerImpl(c);
    }

    public BoltDeclarer setBolt(String id, ITridentBatchBolt bolt, Integer parallelism, Set<String> committerBatches, Map<String, String> batchGroups) {
        this.markBatchGroups(id, batchGroups);
        Component c = new Component(bolt, parallelism, committerBatches);
        this.bolts.put(id, c);
        return new BoltDeclarerImpl(c);
    }

    String masterCoordinator(String batchGroup) {
        return "$mastercoord-" + batchGroup;
    }

    Map<GlobalStreamId, String> fleshOutStreamBatchIds(boolean includeCommitStream) {
        HashMap<GlobalStreamId, String> ret = new HashMap<GlobalStreamId, String>(this.batchIds);
        HashSet<String> allBatches = new HashSet<String>(this.batchIds.values());
        for (String b : allBatches) {
            ret.put(new GlobalStreamId(this.masterCoordinator(b), "$batch"), b);
            if (!includeCommitStream) continue;
            ret.put(new GlobalStreamId(this.masterCoordinator(b), "$commit"), b);
        }
        for (String id : this.spouts.keySet()) {
            TransactionalSpoutComponent c = this.spouts.get(id);
            if (c.batchGroupId == null) continue;
            ret.put(new GlobalStreamId(TridentTopologyBuilder.spoutCoordinator(id), "$batch"), c.batchGroupId);
        }
        for (GlobalStreamId s : this.batchIds.keySet()) {
            String b = this.batchIds.get(s);
            ret.put(new GlobalStreamId(s.get_componentId(), TridentBoltExecutor.coordStream(b)), b);
        }
        return ret;
    }

    public StormTopology buildTopology(Map<String, Number> masterCoordResources) {
        SpoutComponent c;
        TopologyBuilder builder = new TopologyBuilder();
        Map<GlobalStreamId, String> batchIdsForSpouts = this.fleshOutStreamBatchIds(false);
        Map<GlobalStreamId, String> batchIdsForBolts = this.fleshOutStreamBatchIds(true);
        HashMap batchesToCommitIds = new HashMap();
        HashMap batchesToSpouts = new HashMap();
        for (String id : this.spouts.keySet()) {
            c = this.spouts.get(id);
            if (c.spout instanceof IRichSpout) {
                builder.setSpout(id, (IRichSpout)c.spout, (Number)c.parallelism);
                continue;
            }
            String batchGroup = c.batchGroupId;
            if (!batchesToCommitIds.containsKey(batchGroup)) {
                batchesToCommitIds.put(batchGroup, new ArrayList());
            }
            ((List)batchesToCommitIds.get(batchGroup)).add(c.commitStateId);
            if (!batchesToSpouts.containsKey(batchGroup)) {
                batchesToSpouts.put(batchGroup, new ArrayList());
            }
            ((List)batchesToSpouts.get(batchGroup)).add((ITridentSpout)c.spout);
            BoltDeclarer scd = (BoltDeclarer)((BoltDeclarer)builder.setBolt(TridentTopologyBuilder.spoutCoordinator(id), new TridentSpoutCoordinator(c.commitStateId, (ITridentSpout)c.spout)).globalGrouping(this.masterCoordinator(c.batchGroupId), "$batch")).globalGrouping(this.masterCoordinator(c.batchGroupId), "$success");
            for (SharedMemory request : c.sharedMemory) {
                scd.addSharedMemory(request);
            }
            scd.addConfigurations(c.componentConf);
            HashMap<String, TridentBoltExecutor.CoordSpec> specs = new HashMap<String, TridentBoltExecutor.CoordSpec>();
            specs.put(c.batchGroupId, new TridentBoltExecutor.CoordSpec());
            BoltDeclarer bd = builder.setBolt(id, new TridentBoltExecutor(new TridentSpoutExecutor(c.commitStateId, c.streamName, (ITridentSpout)c.spout), batchIdsForSpouts, specs), (Number)c.parallelism);
            bd.allGrouping(TridentTopologyBuilder.spoutCoordinator(id), "$batch");
            bd.allGrouping(this.masterCoordinator(batchGroup), "$success");
            if (c.spout instanceof ICommitterTridentSpout) {
                bd.allGrouping(this.masterCoordinator(batchGroup), "$commit");
            }
            bd.addConfigurations(c.componentConf);
        }
        for (String id : this.batchPerTupleSpouts.keySet()) {
            c = this.batchPerTupleSpouts.get(id);
            SpoutDeclarer d = builder.setSpout(id, new RichSpoutBatchTriggerer((IRichSpout)c.spout, c.streamName, c.batchGroupId), (Number)c.parallelism);
            d.addConfigurations(c.componentConf);
        }
        Number onHeap = masterCoordResources.get("topology.component.resources.onheap.memory.mb");
        Number offHeap = masterCoordResources.get("topology.component.resources.offheap.memory.mb");
        Number cpuLoad = masterCoordResources.get("topology.component.cpu.pcore.percent");
        for (String batch : batchesToCommitIds.keySet()) {
            List commitIds = (List)batchesToCommitIds.get(batch);
            SpoutDeclarer masterCoord = builder.setSpout(this.masterCoordinator(batch), new MasterBatchCoordinator(commitIds, (List)batchesToSpouts.get(batch)));
            if (onHeap != null) {
                if (offHeap != null) {
                    masterCoord.setMemoryLoad(onHeap, offHeap);
                } else {
                    masterCoord.setMemoryLoad(onHeap);
                }
            }
            if (cpuLoad == null) continue;
            masterCoord.setCPULoad(cpuLoad);
        }
        for (String id : this.bolts.keySet()) {
            Component c2 = this.bolts.get(id);
            HashMap<String, TridentBoltExecutor.CoordSpec> specs = new HashMap<String, TridentBoltExecutor.CoordSpec>();
            for (GlobalStreamId globalStreamId : this.getBoltSubscriptionStreams(id)) {
                String batch = batchIdsForBolts.get(globalStreamId);
                if (!specs.containsKey(batch)) {
                    specs.put(batch, new TridentBoltExecutor.CoordSpec());
                }
                TridentBoltExecutor.CoordSpec spec = (TridentBoltExecutor.CoordSpec)specs.get(batch);
                TridentBoltExecutor.CoordType ct = this.batchPerTupleSpouts.containsKey(globalStreamId.get_componentId()) ? TridentBoltExecutor.CoordType.single() : TridentBoltExecutor.CoordType.all();
                spec.coords.put(globalStreamId.get_componentId(), ct);
            }
            for (String string : c2.committerBatches) {
                ((TridentBoltExecutor.CoordSpec)specs.get((Object)string)).commitStream = new GlobalStreamId(this.masterCoordinator(string), "$commit");
            }
            BoltDeclarer d = builder.setBolt(id, new TridentBoltExecutor(c2.bolt, batchIdsForBolts, specs), (Number)c2.parallelism);
            for (SharedMemory request : c2.sharedMemory) {
                d.addSharedMemory(request);
            }
            d.addConfigurations(c2.componentConf);
            for (InputDeclaration inputDecl : c2.declarations) {
                inputDecl.declare(d);
            }
            Map<String, Set<String>> map = this.getBoltBatchToComponentSubscriptions(id);
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                for (String comp : entry.getValue()) {
                    d.directGrouping(comp, TridentBoltExecutor.coordStream(entry.getKey()));
                }
            }
            for (String b3 : c2.committerBatches) {
                d.allGrouping(this.masterCoordinator(b3), "$commit");
            }
        }
        return builder.createTopology();
    }

    private void markBatchGroups(String component, Map<String, String> batchGroups) {
        for (Map.Entry<String, String> entry : batchGroups.entrySet()) {
            this.batchIds.put(new GlobalStreamId(component, entry.getKey()), entry.getValue());
        }
    }

    Map<String, Set<String>> getBoltBatchToComponentSubscriptions(String id) {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (GlobalStreamId s : this.getBoltSubscriptionStreams(id)) {
            String b = this.batchIds.get(s);
            if (!ret.containsKey(b)) {
                ret.put(b, new HashSet());
            }
            ((Set)ret.get(b)).add(s.get_componentId());
        }
        return ret;
    }

    List<GlobalStreamId> getBoltSubscriptionStreams(String id) {
        ArrayList<GlobalStreamId> ret = new ArrayList<GlobalStreamId>();
        Component c = this.bolts.get(id);
        for (InputDeclaration d : c.declarations) {
            ret.add(new GlobalStreamId(d.getComponent(), d.getStream()));
        }
        return ret;
    }

    private static class SpoutComponent {
        final Object spout;
        final Integer parallelism;
        final Map<String, Object> componentConf = new HashMap<String, Object>();
        final String batchGroupId;
        final String streamName;
        final Set<SharedMemory> sharedMemory = new HashSet<SharedMemory>();

        SpoutComponent(Object spout, String streamName, Integer parallelism, String batchGroupId) {
            this.spout = spout;
            this.streamName = streamName;
            this.parallelism = parallelism;
            this.batchGroupId = batchGroupId;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class SpoutDeclarerImpl
    extends BaseConfigurationDeclarer<SpoutDeclarer>
    implements SpoutDeclarer {
        SpoutComponent component;

        SpoutDeclarerImpl(SpoutComponent component) {
            this.component = component;
        }

        @Override
        public SpoutDeclarer addConfigurations(Map<String, Object> conf) {
            if (conf != null) {
                this.component.componentConf.putAll(conf);
            }
            return this;
        }

        @Override
        public Map<String, Object> getComponentConfiguration() {
            return this.component.componentConf;
        }

        @Override
        public SpoutDeclarer addSharedMemory(SharedMemory request) {
            this.component.sharedMemory.add(request);
            return this;
        }
    }

    private static class TransactionalSpoutComponent
    extends SpoutComponent {
        public String commitStateId;

        TransactionalSpoutComponent(Object spout, String streamName, Integer parallelism, String commitStateId, String batchGroupId) {
            super(spout, streamName, parallelism, batchGroupId);
            this.commitStateId = commitStateId;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    private static class Component {
        public final ITridentBatchBolt bolt;
        public final Integer parallelism;
        public final List<InputDeclaration> declarations = new ArrayList<InputDeclaration>();
        public final Map<String, Object> componentConf = new HashMap<String, Object>();
        public final Set<String> committerBatches;
        public final Set<SharedMemory> sharedMemory = new HashSet<SharedMemory>();

        Component(ITridentBatchBolt bolt, Integer parallelism, Set<String> committerBatches) {
            this.bolt = bolt;
            this.parallelism = parallelism;
            this.committerBatches = committerBatches;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    private static class BoltDeclarerImpl
    extends BaseConfigurationDeclarer<BoltDeclarer>
    implements BoltDeclarer {
        Component component;

        BoltDeclarerImpl(Component component) {
            this.component = component;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, fields);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final String streamId, final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, streamId, fields);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields));
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final String streamId, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, streamId, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer grouping(final GlobalStreamId stream, final Grouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.grouping(stream, grouping);
                }

                @Override
                public String getComponent() {
                    return stream.get_componentId();
                }

                @Override
                public String getStream() {
                    return stream.get_streamId();
                }
            });
            return this;
        }

        private void addDeclaration(InputDeclaration declaration) {
            this.component.declarations.add(declaration);
        }

        @Override
        public BoltDeclarer addConfigurations(Map<String, Object> conf) {
            if (conf != null) {
                this.component.componentConf.putAll(conf);
            }
            return this;
        }

        @Override
        public Map<String, Object> getComponentConfiguration() {
            return this.component.componentConf;
        }

        @Override
        public BoltDeclarer addSharedMemory(SharedMemory request) {
            this.component.sharedMemory.add(request);
            return this;
        }
    }

    private static interface InputDeclaration {
        public void declare(InputDeclarer var1);

        public String getComponent();

        public String getStream();
    }
}

