/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import org.apache.jackrabbit.oak.plugins.index.IndexingReporter;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUtils.class);

    public static void setCounterOnce(StatisticsProvider statisticsProvider, String name, long value) {
        CounterStats metric = statisticsProvider.getCounterStats(name, StatsOptions.METRICS_ONLY);
        LOG.debug("Setting counter {} to {}", (Object)name, (Object)value);
        if (metric.getCount() != 0L) {
            LOG.warn("Counter was not 0: {} {}", (Object)name, (Object)metric.getCount());
            metric.dec(metric.getCount());
        }
        metric.inc(value);
    }

    public static void addMetric(StatisticsProvider statisticsProvider, IndexingReporter reporter, String name, long value) {
        MetricsUtils.setCounterOnce(statisticsProvider, name, value);
        reporter.addMetric(name, value);
    }

    public static void addMetricByteSize(StatisticsProvider statisticsProvider, IndexingReporter reporter, String name, long value) {
        MetricsUtils.setCounterOnce(statisticsProvider, name, value);
        reporter.addMetricByteSize(name, value);
    }
}

