/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ResourceSerializer
extends JsonSerializer<Resource>
implements ResolvableSerializer {
    private final int maxRecursionLevels;
    private JsonSerializer<Object> calendarSerializer;

    public ResourceSerializer(int maxRecursionLevels) {
        this.maxRecursionLevels = maxRecursionLevels;
    }

    public void serialize(Resource value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.create(value, jgen, 0, provider);
    }

    private void create(Resource resource, JsonGenerator jgen, int currentRecursionLevel, SerializerProvider provider) throws IOException {
        block6: {
            ValueMap propertyMap;
            ValueMap valueMap;
            block4: {
                block5: {
                    jgen.writeStartObject();
                    valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
                    Object object = propertyMap = valueMap != null ? valueMap : (Map)resource.adaptTo(Map.class);
                    if (propertyMap != null) break block4;
                    String value = (String)resource.adaptTo(String.class);
                    if (value == null) break block5;
                    jgen.writeStringField(resource.getName(), value);
                    break block6;
                }
                String[] values = (String[])resource.adaptTo(String[].class);
                if (values == null) break block6;
                jgen.writeArrayFieldStart(resource.getName());
                for (String s : values) {
                    jgen.writeString(s);
                }
                jgen.writeEndArray();
                break block6;
            }
            for (Map.Entry prop : propertyMap.entrySet()) {
                if (prop.getValue() == null) continue;
                this.createProperty(jgen, valueMap, prop.getKey().toString(), prop.getValue(), provider);
            }
        }
        if (this.recursionLevelActive(currentRecursionLevel)) {
            for (Resource n : resource.getChildren()) {
                jgen.writeFieldName(n.getName());
                this.create(n, jgen, currentRecursionLevel + 1, provider);
            }
        }
        jgen.writeEndObject();
    }

    private void createProperty(JsonGenerator jgen, ValueMap valueMap, String key, Object value, SerializerProvider provider) throws IOException {
        Object[] values = null;
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                jgen.writeArrayFieldStart(key);
                jgen.writeEndArray();
                return;
            }
            values = new Object[Array.getLength(value)];
            for (int i = 0; i < length; ++i) {
                values[i] = Array.get(value, i);
            }
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            if (values == null) {
                jgen.writeNumberField(":" + key, this.getLength(valueMap, -1, key, (InputStream)value));
            } else {
                jgen.writeArrayFieldStart(":" + key);
                for (int i = 0; i < values.length; ++i) {
                    jgen.writeNumber(this.getLength(valueMap, i, key, (InputStream)values[i]));
                }
                jgen.writeEndArray();
            }
            return;
        }
        if (!value.getClass().isArray()) {
            jgen.writeFieldName(key);
            this.writeValue(jgen, value, provider);
        } else {
            jgen.writeArrayFieldStart(key);
            for (Object v : values) {
                this.writeValue(jgen, v, provider);
            }
            jgen.writeEndArray();
        }
    }

    private boolean recursionLevelActive(int currentRecursionLevel) {
        return this.maxRecursionLevels < 0 || currentRecursionLevel < this.maxRecursionLevels;
    }

    private long getLength(ValueMap valueMap, int index, String key, InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long length = -1L;
        if (valueMap != null) {
            if (index == -1) {
                length = (Long)valueMap.get(key, (Object)length);
            } else {
                Long[] lengths = (Long[])valueMap.get(key, Long[].class);
                if (lengths != null && lengths.length > index) {
                    length = lengths[index];
                }
            }
        }
        return length;
    }

    private void writeValue(JsonGenerator jgen, Object value, SerializerProvider provider) throws IOException {
        if (value instanceof InputStream) {
            jgen.writeNumber(0);
        } else if (value instanceof Calendar) {
            this.calendarSerializer.serialize(value, jgen, provider);
        } else if (value instanceof Boolean) {
            jgen.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            jgen.writeNumber(((Long)value).longValue());
        } else if (value instanceof Integer) {
            jgen.writeNumber(((Integer)value).intValue());
        } else if (value instanceof Double) {
            jgen.writeNumber(((Double)value).doubleValue());
        } else if (value != null) {
            jgen.writeString(value.toString());
        } else {
            jgen.writeString("");
        }
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        this.calendarSerializer = provider.findValueSerializer(Calendar.class, null);
    }
}

