/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.interfaces.OptionalPrimitivesModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OptionalPrimitivesTest {
    private ModelAdapterFactory factory;

    OptionalPrimitivesTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ChildResourceInjector(), new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{org.apache.sling.models.testmodels.classes.OptionalPrimitivesModel.class, OptionalPrimitivesModel.class, org.apache.sling.models.testmodels.classes.constructorinjection.OptionalPrimitivesModel.class});
    }

    @Test
    void testFieldInjectionClass() {
        ValueMap vm = ValueMap.EMPTY;
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        org.apache.sling.models.testmodels.classes.OptionalPrimitivesModel model = (org.apache.sling.models.testmodels.classes.OptionalPrimitivesModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.OptionalPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)0, (int)model.getByteValue());
        Assertions.assertEquals((int)0, (int)model.getShortValue());
        Assertions.assertEquals((int)0, (int)model.getIntValue());
        Assertions.assertEquals((long)0L, (long)model.getLongValue());
        Assertions.assertEquals((double)0.0, (double)model.getFloatValue(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)model.getDoubleValue(), (double)1.0E-5);
        Assertions.assertEquals((char)'\u0000', (char)model.getCharValue());
        Assertions.assertEquals((Object)false, (Object)model.getBooleanValue());
        Assertions.assertNull((Object)model.getByteObjectValue());
        Assertions.assertNull((Object)model.getShortObjectValue());
        Assertions.assertNull((Object)model.getIntObjectValue());
        Assertions.assertNull((Object)model.getLongObjectValue());
        Assertions.assertNull((Object)model.getFloatObjectValue());
        Assertions.assertNull((Object)model.getDoubleObjectValue());
        Assertions.assertNull((Object)model.getCharObjectValue());
        Assertions.assertNull((Object)model.getBooleanObjectValue());
    }

    @Test
    void testConstructorInjection() {
        ValueMap vm = ValueMap.EMPTY;
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        org.apache.sling.models.testmodels.classes.constructorinjection.OptionalPrimitivesModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.OptionalPrimitivesModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.constructorinjection.OptionalPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)0, (int)model.getByteValue());
        Assertions.assertEquals((int)0, (int)model.getShortValue());
        Assertions.assertEquals((int)0, (int)model.getIntValue());
        Assertions.assertEquals((long)0L, (long)model.getLongValue());
        Assertions.assertEquals((double)0.0, (double)model.getFloatValue(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)model.getDoubleValue(), (double)1.0E-5);
        Assertions.assertEquals((char)'\u0000', (char)model.getCharValue());
        Assertions.assertEquals((Object)false, (Object)model.getBooleanValue());
        Assertions.assertNull((Object)model.getByteObjectValue());
        Assertions.assertNull((Object)model.getShortObjectValue());
        Assertions.assertNull((Object)model.getIntObjectValue());
        Assertions.assertNull((Object)model.getLongObjectValue());
        Assertions.assertNull((Object)model.getFloatObjectValue());
        Assertions.assertNull((Object)model.getDoubleObjectValue());
        Assertions.assertNull((Object)model.getCharObjectValue());
        Assertions.assertNull((Object)model.getBooleanObjectValue());
    }

    @Test
    void testFieldInjectionInterface() {
        ValueMap vm = ValueMap.EMPTY;
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        OptionalPrimitivesModel model = (OptionalPrimitivesModel)this.factory.getAdapter((Object)res, OptionalPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)0, (int)model.getByteValue());
        Assertions.assertEquals((int)0, (int)model.getShortValue());
        Assertions.assertEquals((int)0, (int)model.getIntValue());
        Assertions.assertEquals((long)0L, (long)model.getLongValue());
        Assertions.assertEquals((double)0.0, (double)model.getFloatValue(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)model.getDoubleValue(), (double)1.0E-5);
        Assertions.assertEquals((char)'\u0000', (char)model.getCharValue());
        Assertions.assertEquals((Object)false, (Object)model.getBooleanValue());
        Assertions.assertNull((Object)model.getByteObjectValue());
        Assertions.assertNull((Object)model.getShortObjectValue());
        Assertions.assertNull((Object)model.getIntObjectValue());
        Assertions.assertNull((Object)model.getLongObjectValue());
        Assertions.assertNull((Object)model.getFloatObjectValue());
        Assertions.assertNull((Object)model.getDoubleObjectValue());
        Assertions.assertNull((Object)model.getCharObjectValue());
        Assertions.assertNull((Object)model.getBooleanObjectValue());
    }
}

