/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import java.io.InputStream;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class SlingTikaDetector
implements Detector {
    private final MimeTypeService mimeTypeService;

    public SlingTikaDetector(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public MediaType detect(InputStream rawData, Metadata metadata) {
        String name = metadata.get("resourceName");
        if (name != null) {
            String type;
            int slash = name.lastIndexOf(47);
            if (slash != -1) {
                name = name.substring(slash + 1);
            }
            if (name.length() > 0 && (type = this.mimeTypeService.getMimeType(name)) != null) {
                return MediaType.parse((String)type);
            }
        }
        return MediaType.OCTET_STREAM;
    }
}

