/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.jcr.resource.internal.helper.CalendarConverter;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.jetbrains.annotations.NotNull;

public class NumberConverter
implements Converter {
    private final Number value;

    public NumberConverter(Number val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    @NotNull
    public Long toLong() {
        return this.value.longValue();
    }

    @Override
    @NotNull
    public Byte toByte() {
        return this.value.byteValue();
    }

    @Override
    @NotNull
    public Short toShort() {
        return this.value.shortValue();
    }

    @Override
    @NotNull
    public Integer toInteger() {
        return this.value.intValue();
    }

    @Override
    @NotNull
    public Double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    @NotNull
    public Float toFloat() {
        return Float.valueOf(this.value.floatValue());
    }

    @Override
    @NotNull
    public ZonedDateTime toZonedDateTime() {
        return new CalendarConverter(this.toCalendar()).toZonedDateTime();
    }

    @Override
    @NotNull
    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    @Override
    @NotNull
    public Date toDate() {
        return new Date(this.toLong());
    }

    @Override
    @NotNull
    public Boolean toBoolean() {
        return false;
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }
}

