/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.jmx.InstallerMBean;

public class InstallerMBeanImpl
implements InstallationListener,
InstallerMBean {
    private final InfoProvider infoProvider;
    private volatile boolean active;
    private volatile long lastEventTime;

    public InstallerMBeanImpl(InfoProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    @Override
    public void onEvent(InstallationEvent event) {
        switch (event.getType()) {
            case STARTED: {
                this.active = true;
                break;
            }
            case SUSPENDED: {
                this.active = false;
                break;
            }
        }
        this.lastEventTime = System.currentTimeMillis();
    }

    @Override
    public int getActiveResourceCount() {
        return this.infoProvider.getInstallationState().getActiveResources().size();
    }

    @Override
    public int getInstalledResourceCount() {
        return this.infoProvider.getInstallationState().getInstalledResources().size();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getSuspendedSince() {
        return this.active ? -1L : this.lastEventTime;
    }
}

