/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.xml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserHelper;
import org.apache.sling.contentparser.api.ParserOptions;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(property={"org.apache.sling.contentparser.content_type=xml"})
public final class XMLContentParser
implements ContentParser {
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private final DocumentBuilderFactory documentBuilderFactory;

    public XMLContentParser() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            dbf.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            dbf.setExpandEntityReferences(false);
            this.documentBuilderFactory = dbf;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot disable DTD features.", e);
        }
    }

    @Override
    public void parse(ContentHandler handler, InputStream is, ParserOptions parserOptions) throws IOException {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(is);
            this.parse(handler, doc.getDocumentElement(), parserOptions, null);
        }
        catch (Exception ex) {
            throw new IOException("Error parsing JCR XML content.", ex);
        }
    }

    private void parse(ContentHandler handler, Element element, ParserOptions parserOptions, String parentPath) throws IOException {
        String[] mixins;
        String path;
        if (parentPath == null) {
            path = "/";
        } else {
            String name = this.getChildText(element, "name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                throw new IOException("Child node without name detected below path " + parentPath);
            }
            if (parserOptions.getIgnoreResourceNames().contains(name)) {
                return;
            }
            path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String primaryType = this.getChildText(element, "primaryNodeType");
        if (StringUtils.isNotBlank((CharSequence)primaryType) && !parserOptions.getIgnorePropertyNames().contains(JCR_PRIMARY_TYPE)) {
            properties.put(JCR_PRIMARY_TYPE, primaryType);
        }
        if ((mixins = this.getChildTextArray(element, "mixinNodeType")).length > 0 && !parserOptions.getIgnorePropertyNames().contains("jcr:mixinTypes")) {
            properties.put("jcr:mixinTypes", mixins);
        }
        List<Element> propertyElements = this.getChildren(element, "property");
        for (Element propertyElement : propertyElements) {
            Object value;
            String name = this.getChildText(propertyElement, "name");
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IOException("Property without name detected at path " + path);
            }
            if (parserOptions.getIgnorePropertyNames().contains(name)) continue;
            String type = this.getChildText(propertyElement, "type");
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new IOException("Property '" + name + "' has no type at path " + path);
            }
            List<Element> valuesElements = this.getChildren(propertyElement, "values");
            if (!valuesElements.isEmpty()) {
                Element valuesElement = valuesElements.get(0);
                List<Element> valueElements = this.getChildren(valuesElement, "value");
                String[] stringValues = new String[valueElements.size()];
                for (int i = 0; i < valueElements.size(); ++i) {
                    stringValues[i] = valueElements.get(i).getTextContent();
                }
                value = this.convertMultiValue(stringValues, type);
            } else {
                String stringValue = this.getChildText(propertyElement, "value");
                value = this.convertValue(stringValue, type);
            }
            properties.put(name, value);
        }
        String defaultPrimaryType = parserOptions.getDefaultPrimaryType();
        if (defaultPrimaryType != null && !properties.containsKey(JCR_PRIMARY_TYPE)) {
            properties.put(JCR_PRIMARY_TYPE, defaultPrimaryType);
        }
        handler.resource(path, properties);
        List<Element> nodeElements = this.getChildren(element, "node");
        for (Element node : nodeElements) {
            this.parse(handler, node, parserOptions, path);
        }
    }

    private List<Element> getChildren(Element element, String childName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Element childElement;
            Node child = children.item(i);
            if (!(child instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)child).getNodeName(), (CharSequence)childName)) continue;
            result.add(childElement);
        }
        return result;
    }

    private String getChildText(Element element, String childName) throws IOException {
        List<Element> children = this.getChildren(element, childName);
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1) {
            return children.get(0).getTextContent();
        }
        throw new IOException("Found multiple elements with name '" + childName + "': " + children.size());
    }

    private String[] getChildTextArray(Element element, String childName) {
        List<Element> children = this.getChildren(element, childName);
        String[] result = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            result[i] = children.get(i).getTextContent();
        }
        return result;
    }

    private Object convertValue(String value, String type) {
        switch (type) {
            case "String": 
            case "Name": 
            case "Path": 
            case "Reference": 
            case "WeakReference": 
            case "URI": {
                return value;
            }
            case "Long": {
                return Long.valueOf(value);
            }
            case "Double": {
                return Double.valueOf(value);
            }
            case "Date": {
                return ParserHelper.parseDate(value);
            }
            case "Boolean": {
                return Boolean.valueOf(value);
            }
            case "Decimal": {
                return new BigDecimal(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported property type: %s.", type));
    }

    private Object convertMultiValue(String[] values, String type) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.convertValue(values[i], type);
        }
        return ParserHelper.convertSingleTypeArray(result);
    }
}

