/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.dea.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public abstract class ResourceHelper {
    public static final String PROPERTY_MARKER_READ_ERROR_LIST = ResourceHelper.class.getName() + "/ReadErrorList";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> cloneValueMap(ValueMap vm) throws InstantiationException {
        ArrayList<Exception> hasReadError = null;
        try {
            HashMap<String, Object> result = new HashMap<String, Object>((Map<String, Object>)vm);
            for (Map.Entry entry : result.entrySet()) {
                if (!(entry.getValue() instanceof InputStream)) continue;
                Object value = vm.get((String)entry.getKey(), Serializable.class);
                if (value != null) {
                    entry.setValue(value);
                    continue;
                }
                if (hasReadError == null) {
                    hasReadError = new ArrayList<Exception>();
                }
                int count = hasReadError.size();
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream((InputStream)entry.getValue());
                    ois.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'", cnfe));
                }
                catch (IOException ioe) {
                    hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'", ioe));
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException cnfe) {}
                    }
                }
                if (hasReadError.size() != count) continue;
                hasReadError.add(new Exception("Unable to deserialize property '" + (String)entry.getKey() + "'"));
            }
            if (hasReadError != null) {
                result.put(PROPERTY_MARKER_READ_ERROR_LIST, hasReadError);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            throw (InstantiationException)new InstantiationException(iae.getMessage()).initCause(iae);
        }
    }

    public static ValueMap getValueMap(Resource resource) throws InstantiationException {
        ValueMap vm = ResourceUtil.getValueMap((Resource)resource);
        try {
            vm.size();
        }
        catch (IllegalArgumentException iae) {
            throw (InstantiationException)new InstantiationException(iae.getMessage()).initCause(iae);
        }
        return vm;
    }

    public static BatchResourceRemover getBatchResourceRemover(int threshold) {
        return new BatchResourceRemover(threshold);
    }

    public static class BatchResourceRemover {
        private final int max;
        private int count;

        public BatchResourceRemover(int batchSize) {
            this.max = batchSize < 1 ? 50 : batchSize;
        }

        public void delete(Resource rsrc) throws PersistenceException {
            ResourceResolver resolver = rsrc.getResourceResolver();
            for (Resource child : rsrc.getChildren()) {
                this.delete(child);
            }
            resolver.delete(rsrc);
            ++this.count;
            if (this.count >= this.max) {
                resolver.commit();
                this.count = 0;
            }
        }
    }
}

