/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.commons.scheduler.impl.QuartzSchedulerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHolder {
    private static final Logger logger = LoggerFactory.getLogger(ConfigHolder.class);
    private final QuartzSchedulerConfiguration config;
    private final Map<String, String> filterSuffixes = new HashMap<String, String>();
    private final Map<String, Map<String, String>> filterDefinitions = new HashMap<String, Map<String, String>>();

    ConfigHolder(QuartzSchedulerConfiguration config) {
        this.config = config;
        if (config == null) {
            return;
        }
        String[] groupFilter = config.metrics_filters();
        if (groupFilter == null) {
            return;
        }
        for (String aFilterDefinition : groupFilter) {
            String[] split = aFilterDefinition.split("=");
            if (split == null || split.length != 2) {
                logger.warn("activate: ignoring wrongly formatted (expects 1 '=') filter definition: " + aFilterDefinition);
                continue;
            }
            String packageName = ConfigHolder.packageOf(split[1]);
            if (packageName == null) {
                logger.warn("activate: ignoring wrongly formatted filter definition, expected fully qualified class name (except $anonymous or $inner class part) :" + aFilterDefinition);
                continue;
            }
            if (split[1].contains("$") || split[1].contains("*") || split[1].contains("?")) {
                logger.warn("activate: ignoring wrongly formatted filter definition, disallowed character(s) used ($, *, ?) :" + aFilterDefinition);
                continue;
            }
            this.filterSuffixes.put(split[0], split[1]);
            Map<String, String> map = this.filterDefinitions.get(packageName);
            if (map == null) {
                map = new HashMap<String, String>();
                this.filterDefinitions.put(packageName, map);
            }
            map.put(split[1], split[0]);
        }
    }

    static String packageOf(String jobClass) {
        int lastDot = jobClass.lastIndexOf(".");
        if (lastDot == -1) {
            return null;
        }
        return jobClass.substring(0, lastDot);
    }

    String poolName() {
        if (this.config == null) {
            return "default";
        }
        return this.config.poolName();
    }

    String[] allowedPoolNames() {
        if (this.config == null) {
            return null;
        }
        return this.config.allowedPoolNames();
    }

    long slowThresholdMillis() {
        if (this.config == null) {
            return 1000L;
        }
        return this.config.slowThresholdMillis();
    }

    Map<String, String> getFilterSuffixes() {
        return this.filterSuffixes;
    }

    Map<String, Map<String, String>> getFilterDefinitions() {
        return this.filterDefinitions;
    }
}

