/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;

public final class GridAdjustment {
    private double[] gridToDataIndices;
    final Map<Dimension, Dimension> gridToVariable = new HashMap<Dimension, Dimension>();

    GridAdjustment() {
    }

    boolean mapLabelToGridDimensions(Variable variable, List<Variable> axes, Map<Object, Dimension> toGridDimensions, Convention convention) {
        HashSet<Dimension> requestedByConvention = new HashSet<Dimension>();
        String[] namesOfAxisVariables = convention.namesOfAxisVariables(variable);
        for (Variable axis : axes) {
            boolean isRequested = ArraysExt.containsIgnoreCase((String[])namesOfAxisVariables, (String)axis.getName());
            List<Dimension> candidates = axis.getGridDimensions();
            int j = candidates.size();
            while (--j >= 0) {
                boolean overwrite;
                String name;
                Dimension dim = candidates.get(j);
                if (!toGridDimensions.containsKey(dim) || (name = convention.nameOfDimension(axis, j)) == null) continue;
                if (this.gridToDataIndices == null) {
                    this.gridToDataIndices = new double[axes.size()];
                }
                this.gridToDataIndices[j] = convention.gridToDataIndices(axis);
                boolean bl = overwrite = isRequested && requestedByConvention.add(dim);
                Dimension previous = toGridDimensions.put(name, dim);
                if (previous == null || previous.equals(dim) || overwrite) continue;
                if (!isRequested && requestedByConvention.contains(dim)) {
                    toGridDimensions.put(name, previous);
                    continue;
                }
                variable.error(Variable.class, "getGridGeometry", null, (short)39, name);
                return true;
            }
        }
        return false;
    }

    final double[] dataToGridIndices() {
        double[] dataToGridIndices = null;
        if (this.gridToDataIndices != null) {
            int i = this.gridToDataIndices.length;
            while (--i >= 0) {
                double s = this.gridToDataIndices[i];
                if (s > 0.0 && s != Double.POSITIVE_INFINITY) {
                    if (dataToGridIndices == null) {
                        dataToGridIndices = new double[i + 1];
                    }
                    dataToGridIndices[i] = 1.0 / s;
                    continue;
                }
                dataToGridIndices = null;
            }
        }
        return dataToGridIndices;
    }

    static GridGeometry scale(GridGeometry geometry, GridExtent extent, PixelInCell anchor, double[] dataToGridIndices) {
        MathTransform gridToCRS = geometry.getGridToCRS(anchor);
        LinearTransform scale = MathTransforms.scale((double[])dataToGridIndices);
        gridToCRS = MathTransforms.concatenate((MathTransform)scale, (MathTransform)gridToCRS);
        return new GridGeometry(extent, anchor, gridToCRS, geometry.isDefined(1) ? geometry.getCoordinateReferenceSystem() : null);
    }
}

