/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.ref.Reference;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.pending.jdk.JDK16;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.AxisName;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.CoordinateOperationSet;
import org.apache.sis.referencing.factory.sql.EPSGCodeFinder;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.factory.sql.ObjectPertinence;
import org.apache.sis.referencing.factory.sql.SQLTranslator;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.referencing.internal.DeferredCoordinateOperation;
import org.apache.sis.referencing.internal.DeprecatedCode;
import org.apache.sis.referencing.internal.Epoch;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.PositionalAccuracyConstant;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.SignReversalComment;
import org.apache.sis.referencing.internal.VerticalDatumTypes;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.system.Semaphores;
import org.apache.sis.temporal.LenientDateFormat;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

public class EPSGDataAccess
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
Localized,
AutoCloseable {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.factory");
    private static final Set<Integer> EPSG_CODE_PARAMETERS = Set.of(Integer.valueOf(1048), Integer.valueOf(1062));
    private static final String UNKNOWN_SCOPE = "?";
    private static final String PARAMETER_TYPE_OPTION = "type";
    private static final String URI_TYPE = "URI";
    private static final String UOM_CODE_OPTION = "uom_code";
    private static final String SIGN_REVERSAL_OPTION = "sign_reversal";
    private final NameSpace namespace;
    private final Map<String, PreparedStatement> statements = new HashMap<String, PreparedStatement>();
    private final Map<Object, CloseableReference> authorityCodes = new HashMap<Object, CloseableReference>();
    private final Map<Object, Object> localCache = new HashMap<Object, Object>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private QueryID currentSingletonQuery;
    transient boolean quiet;
    private transient boolean replaceDeprecatedCS;
    protected final EPSGFactory owner;
    protected final Connection connection;
    protected final SQLTranslator translator;

    static int replaceDeprecatedCS(int code) {
        if (code == 6402 || code >= 6405 && code <= 6412) {
            return 6422;
        }
        if (code == 6401 || code >= 6413 && code <= 6420) {
            return 6423;
        }
        return code;
    }

    private static Long cacheKey(int type, int code) {
        return (long)type << 32 | Integer.toUnsignedLong(code);
    }

    protected EPSGDataAccess(EPSGFactory owner, Connection connection, SQLTranslator translator) throws SQLException {
        this.owner = owner;
        this.connection = Objects.requireNonNull(connection);
        this.translator = Objects.requireNonNull(translator);
        this.namespace = owner.nameFactory.createNameSpace((GenericName)owner.nameFactory.createLocalName(null, (CharSequence)"IOGP"), null);
        connection.setCatalog(translator.getCatalog());
        connection.setSchema(translator.getSchema());
    }

    public Locale getLocale() {
        return this.owner.getLocale();
    }

    @Override
    public synchronized Citation getAuthority() {
        DefaultCitation c = new DefaultCitation((Citation)Citations.EPSG);
        try {
            String query = this.translator.apply("SELECT VERSION_NUMBER, VERSION_DATE FROM \"Version History\" ORDER BY VERSION_DATE DESC, VERSION_HISTORY_CODE DESC");
            String version = null;
            try (Statement stmt = this.connection.createStatement();
                 ResultSet result = stmt.executeQuery(query);){
                while (result.next()) {
                    version = EPSGDataAccess.getOptionalString(result, 1);
                    Date date = result.getDate(2);
                    if (version == null || date == null) continue;
                    c.setEdition((InternationalString)new SimpleInternationalString(version));
                    c.setEditionDate((Temporal)LocalDate.ofEpochDay(date.getTime() / 86400000L));
                    break;
                }
            }
            DatabaseMetaData metadata = this.connection.getMetaData();
            InternationalString description = Resources.formatInternational((short)18, "EPSG", version, metadata.getDatabaseProductName(), Version.valueOf((int[])new int[]{metadata.getDatabaseMajorVersion(), metadata.getDatabaseMinorVersion()}));
            DefaultOnlineResource r = new DefaultOnlineResource();
            try {
                r.setLinkage(new URI(SQLUtilities.getSimplifiedURL((DatabaseMetaData)metadata)));
            }
            catch (URISyntaxException exception) {
                Logging.recoverableException((Logger)LOGGER, EPSGDataAccess.class, (String)"getAuthority", (Throwable)exception);
            }
            r.setFunction(OnLineFunction.valueOf((String)"CONNECTION"));
            r.setDescription(description);
            c.getOnlineResources().add(r);
        }
        catch (SQLException exception) {
            EPSGDataAccess.unexpectedException("getAuthority", exception);
        }
        c.transitionTo(ModifiableMetadata.State.FINAL);
        return c;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        try {
            if (this.connection.isClosed()) {
                throw new FactoryException(this.error().getString((short)31));
            }
            AuthorityCodes codes = this.getCodeMap(Objects.requireNonNull(type), null, true);
            if (codes != null) {
                return codes.keySet();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), (Throwable)Exceptions.unwrap((Exception)exception));
        }
        return Set.of();
    }

    final boolean getAuthorityCodes(IdentifiedObject object, Collection<Integer> addTo) throws SQLException {
        AuthorityCodes codes = this.getCodeMap(TableInfo.toCacheKey(object), null, false);
        return codes != null && codes.getAllCodes(addTo);
    }

    private synchronized AuthorityCodes getCodeMap(Object cacheKey, TableInfo source, boolean publish) throws SQLException {
        AuthorityCodes existing;
        CloseableReference reference = this.authorityCodes.get(cacheKey);
        if (reference != null && (existing = (AuthorityCodes)reference.get()) != null) {
            reference.published |= publish;
            return existing;
        }
        if (source != null) {
            assert (source.isSpecificEnough() && source.type.isAssignableFrom(TableInfo.typeOfCacheKey(cacheKey))) : source;
        } else {
            Class<?> userType = TableInfo.typeOfCacheKey(cacheKey);
            for (TableInfo candidate : TableInfo.values()) {
                if (!candidate.isSpecificEnough() || !candidate.type.isAssignableFrom(userType)) continue;
                if (source != null) {
                    return null;
                }
                source = candidate;
            }
            if (source == null) {
                return null;
            }
        }
        AuthorityCodes codes = new AuthorityCodes(source, cacheKey, this);
        reference = this.authorityCodes.get(codes.cacheKey);
        if (reference != null) {
            AuthorityCodes existing2 = (AuthorityCodes)reference.get();
            if (existing2 != null) {
                codes = existing2;
            } else {
                reference = null;
            }
        }
        if (reference == null) {
            reference = codes.createReference();
            this.authorityCodes.put(codes.cacheKey, reference);
        }
        if (cacheKey != codes.cacheKey) {
            this.authorityCodes.put(cacheKey, reference);
        }
        reference.published |= publish;
        return codes;
    }

    @Override
    public Set<String> getCodeSpaces() {
        return Set.of();
    }

    @Override
    public Optional<InternationalString> getDescriptionText(Class<? extends IdentifiedObject> type, String code) throws FactoryException {
        try {
            String text;
            AuthorityCodes codes = this.getCodeMap(Objects.requireNonNull(type), null, false);
            if (codes != null && (text = codes.get(code)) != null) {
                return Optional.of(new SimpleInternationalString(text));
            }
        }
        catch (SQLException | BackingStoreException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), (Throwable)Exceptions.unwrap((Exception)exception));
        }
        return Optional.empty();
    }

    private static String codeWithOptions(String code, Map<String, String> options) {
        if (options.isEmpty()) {
            return code;
        }
        StringBuilder s = new StringBuilder(code);
        int separator = 63;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            s.append((char)separator).append(entry.getKey()).append('=').append(entry.getValue());
            separator = 38;
        }
        return s.toString();
    }

    private static String separateOptions(String code, Map<String, String> options) {
        int s = code.indexOf(63);
        if (s < 0) {
            return code;
        }
        for (String option : (String[])CharSequences.split((CharSequence)code.substring(s + 1), (char)'&')) {
            int e = option.indexOf(61);
            if (s < 0) continue;
            options.put(option.substring(0, e).trim().toLowerCase(Locale.US), option.substring(e + 1).trim());
        }
        return code.substring(0, s);
    }

    private static boolean isPrimaryKey(String code) {
        int i = code.length();
        if (i == 0) {
            return false;
        }
        do {
            char c;
            if ((c = code.charAt(--i)) >= '0' && c <= '9') continue;
            return false;
        } while (i != 0);
        return true;
    }

    private int[] toPrimaryKeys(TableInfo source, String ... codes) throws SQLException, FactoryException {
        int[] primaryKeys = new int[codes.length];
        for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            if (source != null && !EPSGDataAccess.isPrimaryKey(code)) {
                ArrayList<Integer> result = new ArrayList<Integer>();
                this.findCodesFromName(source, source.type, code, result);
                if (result.isEmpty()) {
                    this.findCodesFromAlias(source, code, result);
                }
                Integer resolved = null;
                for (Integer value : result) {
                    if (resolved == null) {
                        resolved = value;
                        continue;
                    }
                    if (resolved.equals(value)) continue;
                    throw new NoSuchAuthorityCodeException(this.error().getString((short)39, (Object)code), "EPSG", code);
                }
                if (resolved != null) {
                    primaryKeys[i] = resolved;
                    continue;
                }
            }
            try {
                primaryKeys[i] = Integer.parseInt(code);
                continue;
            }
            catch (NumberFormatException e) {
                throw (NoSuchAuthorityCodeException)new NoSuchAuthorityCodeException(this.error().getString((short)68, (Object)"EPSG", (Object)code), "EPSG", code).initCause((Throwable)e);
            }
        }
        return primaryKeys;
    }

    final void findCodesFromName(TableInfo source, Object cacheKey, String name, Collection<Integer> addTo) throws SQLException {
        AuthorityCodes codes = this.getCodeMap(cacheKey, source, false);
        if (codes != null) {
            codes.findCodesFromName(name, addTo);
        }
    }

    final void findCodesFromAlias(TableInfo source, String name, Collection<Integer> addTo) throws SQLException {
        PreparedStatement stmt = this.prepareStatement("AliasKey", "SELECT OBJECT_CODE, ALIAS FROM \"Alias\" WHERE OBJECT_TABLE_NAME=? AND ALIAS=?");
        stmt.setString(1, this.translator.toActualTableName(source.table));
        stmt.setString(2, name);
        try (ResultSet result = stmt.executeQuery();){
            while (result.next()) {
                addTo.add(EPSGDataAccess.getOptionalInteger(result, 1));
            }
        }
    }

    private ResultSet executeSingletonQuery(TableInfo source, String sql, String ... codes) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        assert (source.validate(sql)) : source;
        int[] keys = this.toPrimaryKeys(source, codes);
        this.currentSingletonQuery = new QueryID(source.table, keys, this.currentSingletonQuery);
        if (this.currentSingletonQuery.isAlreadyInProgress()) {
            throw new FactoryDataException(this.resources().getString((short)62, source.type.getSimpleName(), codes.length == 1 ? codes[0] : Arrays.toString(codes)));
        }
        return this.executeQueryForCodes(source.table, sql, keys);
    }

    private ResultSet executeQueryForCodes(String table, String sql, int ... codes) throws SQLException {
        assert (Thread.holdsLock(this));
        assert (CharSequences.count((CharSequence)sql, (char)'?') == codes.length);
        PreparedStatement stmt = this.prepareStatement(table, sql);
        assert (stmt.getParameterMetaData().getParameterCount() == codes.length);
        for (int i = 0; i < codes.length; ++i) {
            stmt.setInt(i + 1, codes[i]);
        }
        return stmt.executeQuery();
    }

    private ResultSet executeMetadataQuery(String key, String sql, String table, int code) throws SQLException {
        assert (Thread.holdsLock(this));
        assert (CharSequences.count((CharSequence)sql, (char)'?') == 2);
        PreparedStatement stmt = this.prepareStatement(key, sql);
        assert (stmt.getParameterMetaData().getParameterCount() == 2);
        stmt.setString(1, table);
        stmt.setInt(2, code);
        return stmt.executeQuery();
    }

    private PreparedStatement prepareStatement(String table, String sql) throws SQLException {
        PreparedStatement stmt = this.statements.get(table);
        if (stmt == null) {
            stmt = this.connection.prepareStatement(this.translator.apply(sql));
            this.statements.put(table, stmt);
        }
        return stmt;
    }

    private static Temporal getOptionalTemporal(ResultSet result, int columnIndex, String caller) throws SQLException {
        try {
            return LenientDateFormat.parseBest((CharSequence)EPSGDataAccess.getOptionalString(result, columnIndex));
        }
        catch (NumberFormatException exception) {
            EPSGDataAccess.unexpectedException(caller, exception);
            return null;
        }
    }

    private static Temporal getOptionalEpoch(ResultSet result, int columnIndex) throws SQLException {
        return Epoch.fromYear(EPSGDataAccess.getOptionalDouble(result, columnIndex), 0);
    }

    private static String getOptionalString(ResultSet result, int columnIndex) throws SQLException {
        String value = Strings.trimOrNull((String)result.getString(columnIndex));
        return value == null || result.wasNull() ? null : value;
    }

    private static double getOptionalDouble(ResultSet result, int columnIndex) throws SQLException {
        double value = result.getDouble(columnIndex);
        return result.wasNull() ? Double.NaN : value;
    }

    private static Integer getOptionalInteger(ResultSet result, int columnIndex) throws SQLException {
        int value = result.getInt(columnIndex);
        return result.wasNull() ? null : Integer.valueOf(value);
    }

    private boolean getBoolean(ResultSet result, int columnIndex) throws SQLException {
        return this.translator.useBoolean() ? result.getBoolean(columnIndex) : result.getInt(columnIndex) != 0;
    }

    private Boolean getOptionalBoolean(ResultSet result, int columnIndex) throws SQLException {
        Boolean value = this.translator.useBoolean() ? Boolean.valueOf(result.getBoolean(columnIndex)) : SQLUtilities.parseBoolean((String)result.getString(columnIndex));
        return result.wasNull() ? null : value;
    }

    private String nullValue(ResultSet result, int columnIndex, Comparable<?> code) throws SQLException {
        ResultSetMetaData metadata = result.getMetaData();
        String column = metadata.getColumnName(columnIndex);
        String table = metadata.getTableName(columnIndex);
        return this.error().getString((short)145, (Object)table, (Object)column, code);
    }

    private String getString(String code, ResultSet result, int columnIndex, int columnFault) throws SQLException, FactoryDataException {
        String value = Strings.trimOrNull((String)result.getString(columnIndex));
        if (value == null || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnFault, (Comparable<?>)((Object)code)));
        }
        return value;
    }

    private String getString(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        String value = Strings.trimOrNull((String)result.getString(columnIndex));
        if (value == null || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private double getDouble(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        double value = result.getDouble(columnIndex);
        if (Double.isNaN(value) || result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private Integer getInteger(Comparable<?> code, ResultSet result, int columnIndex) throws SQLException, FactoryDataException {
        int value = result.getInt(columnIndex);
        if (result.wasNull()) {
            throw new FactoryDataException(this.nullValue(result, columnIndex, code));
        }
        return value;
    }

    private <T> T ensureSingleton(T newValue, T oldValue, Comparable<?> code) throws FactoryDataException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryDataException(this.error().getString((short)39, code));
    }

    private InternationalString getScope(Integer code) throws SQLException, FactoryDataException {
        Long cacheKey = EPSGDataAccess.cacheKey(1, code);
        InternationalString scope = (InternationalString)this.localCache.get(cacheKey);
        if (scope == null) {
            try (ResultSet result = this.executeQueryForCodes("Scope", "SELECT SCOPE FROM \"Scope\" WHERE SCOPE_CODE=?", code);){
                while (result.next()) {
                    String s = result.getString(1);
                    if (UNKNOWN_SCOPE.equals(s)) continue;
                    scope = this.ensureSingleton(Types.toInternationalString((CharSequence)s), scope, code);
                }
            }
            this.localCache.put(cacheKey, scope);
        }
        return scope;
    }

    private void getUsages(String actualTable, int code, Collection<String> extents, Collection<Integer> scopes) throws SQLException, FactoryDataException {
        try (ResultSet result = this.executeMetadataQuery("Usage", "SELECT EXTENT_CODE, SCOPE_CODE FROM \"Usage\" WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=?", actualTable, code);){
            while (result.next()) {
                if (extents != null) {
                    extents.add(this.getString(Integer.valueOf(code), result, 1));
                }
                if (scopes == null) continue;
                scopes.add(this.getInteger(Integer.valueOf(code), result, 2));
            }
        }
    }

    private String getReplacement(TableInfo source, int code, Locale locale) throws SQLException {
        Object replacedBy;
        String reason;
        block9: {
            reason = null;
            try (ResultSet result = this.executeMetadataQuery("Deprecation", "SELECT DEPRECATION_REASON, REPLACED_BY FROM \"Deprecation\" WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=?", this.translator.toActualTableName(source.table), code);){
                while (result.next()) {
                    reason = EPSGDataAccess.getOptionalString(result, 1);
                    Integer r = EPSGDataAccess.getOptionalInteger(result, 2);
                    if (r == null) continue;
                    replacedBy = r.toString();
                    break block9;
                }
                replacedBy = "(" + Vocabulary.forLocale((Locale)locale).getString((short)141).toLowerCase(locale) + ")";
            }
        }
        if (!this.quiet) {
            Logging.completeAndLog((Logger)LOGGER, EPSGDataAccess.class, (String)"create".concat(source.type.getSimpleName()), (LogRecord)Resources.forLocale(locale).createLogRecord(Semaphores.FINER_LOG_LEVEL_FOR_DEPRECATION.getLogLevel(Level.WARNING), (short)15, "EPSG:" + code, replacedBy, reason));
        }
        return replacedBy;
    }

    private ReferenceIdentifier createIdentifier(TableInfo source, int code, String identifier, InternationalString description, Locale locale, boolean deprecated) throws SQLException, FactoryException {
        Citation authority = this.owner.getAuthority();
        String version = Types.toString((InternationalString)authority.getEdition(), (Locale)locale);
        if (deprecated) {
            String replacedBy = this.getReplacement(source, code, locale);
            return new DeprecatedCode(authority, "EPSG", identifier, version, description, Character.isDigit(replacedBy.charAt(0)) ? replacedBy : null, Vocabulary.formatInternational((short)190, (Object)replacedBy));
        }
        return new ImmutableIdentifier(authority, "EPSG", identifier, version, description);
    }

    private Map<String, Object> createProperties(TableInfo source, Integer code, String name, CharSequence description, String extentCode, String scope, CharSequence remarks, boolean deprecated) throws SQLException, FactoryException {
        Extent extent = extentCode == null ? null : this.createExtent(extentCode);
        String actualTable = this.translator.toActualTableName(source.table);
        DefaultObjectDomain[] domains = null;
        if (this.translator.isUsageTableFound()) {
            ArrayList<String> extents = new ArrayList<String>();
            ArrayList<Integer> scopes = new ArrayList<Integer>();
            this.getUsages(actualTable, code, extents, scopes);
            if (!extents.isEmpty()) {
                domains = new DefaultObjectDomain[extents.size()];
                for (int i = 0; i < domains.length; ++i) {
                    domains[i] = new DefaultObjectDomain(this.getScope(scopes.get(i)), this.owner.createExtent(extents.get(i)));
                }
            }
        }
        ArrayList<LocalName> aliases = new ArrayList<LocalName>();
        try (ResultSet result = this.executeMetadataQuery("Alias", "SELECT NAMING_SYSTEM_NAME, ALIAS FROM \"Alias\" INNER JOIN \"Naming System\" ON \"Alias\".NAMING_SYSTEM_CODE = \"Naming System\".NAMING_SYSTEM_CODE WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=?", actualTable, code);){
            while (result.next()) {
                String naming = EPSGDataAccess.getOptionalString(result, 1);
                String alias = this.getString(code, result, 2);
                NameSpace ns = null;
                if (naming != null && (ns = (NameSpace)this.localCache.get(naming)) == null) {
                    ns = this.owner.nameFactory.createNameSpace((GenericName)this.owner.nameFactory.createLocalName(null, (CharSequence)naming), null);
                    this.localCache.put(naming, ns);
                }
                if (CharSequences.toASCII((CharSequence)alias).toString().equals(name)) {
                    name = alias;
                    continue;
                }
                aliases.add(this.owner.nameFactory.createLocalName(ns, (CharSequence)alias));
            }
        }
        Locale locale = this.getLocale();
        Citation authority = this.owner.getAuthority();
        String version = Types.toString((InternationalString)authority.getEdition(), (Locale)locale);
        GenericName scopedName = this.owner.nameFactory.createGenericName(this.namespace, new CharSequence[]{"EPSG", name});
        this.properties.clear();
        this.properties.put("name", scopedName);
        this.properties.put("code", name);
        this.properties.put("version", version);
        this.properties.put("authority", authority);
        this.properties.put("description", description);
        this.properties.put("locale", locale);
        NamedIdentifier nameAsIdentifier = new NamedIdentifier(this.properties);
        this.properties.clear();
        this.properties.put("name", nameAsIdentifier);
        this.properties.put("identifiers", this.createIdentifier(source, code, code.toString(), scopedName.toInternationalString(), locale, deprecated));
        if (!aliases.isEmpty()) {
            this.properties.put("alias", aliases.toArray(GenericName[]::new));
        }
        if (deprecated) {
            this.properties.put("deprecated", Boolean.TRUE);
        }
        this.properties.put("remarks", remarks);
        this.properties.put("locale", locale);
        this.properties.put("mtFactory", this.owner.mtFactory);
        if (domains != null) {
            this.properties.put("domains", domains);
        }
        if (scope != null && !scope.equals(UNKNOWN_SCOPE)) {
            this.properties.put("scope", scope);
        }
        if (extent != null) {
            this.properties.put("domainOfValidity", extent);
        }
        return this.properties;
    }

    @Override
    public synchronized IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        boolean isPrimaryKey = EPSGDataAccess.isPrimaryKey(code);
        StringBuilder query = new StringBuilder("SELECT ");
        int queryStart = query.length();
        Enum found = null;
        try {
            int key = isPrimaryKey ? this.toPrimaryKeys(null, code)[0] : 0;
            for (TableInfo source : TableInfo.values()) {
                if (!source.isSpecificEnough() || !IdentifiedObject.class.isAssignableFrom(source.type)) continue;
                String column = isPrimaryKey ? source.codeColumn : source.nameColumn;
                query.setLength(queryStart);
                query.append(source.codeColumn);
                query.append(" FROM ").append(source.fromClause).append(" WHERE ").append(column).append("=?");
                try (PreparedStatement stmt = this.connection.prepareStatement(this.translator.apply(query.toString()));){
                    if (isPrimaryKey) {
                        stmt.setInt(1, key);
                    } else {
                        stmt.setString(1, code);
                    }
                    Integer present = null;
                    try (ResultSet result = stmt.executeQuery();){
                        while (result.next()) {
                            present = this.ensureSingleton((Object)EPSGDataAccess.getOptionalInteger(result, 1), (Object)present, (Comparable<?>)((Object)code));
                        }
                    }
                    if (present == null) continue;
                    if (found != null) {
                        throw new FactoryDataException(this.error().getString((short)39, (Object)code));
                    }
                    found = source;
                }
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(IdentifiedObject.class, (Comparable<?>)((Object)code), exception);
        }
        if (found != null) {
            switch (1.$SwitchMap$org$apache$sis$referencing$factory$sql$TableInfo[found.ordinal()]) {
                case 1: {
                    return this.createCoordinateReferenceSystem(code);
                }
                case 2: {
                    return this.createCoordinateSystem(code);
                }
                case 3: {
                    return this.createCoordinateSystemAxis(code);
                }
                case 4: {
                    return this.createDatum(code);
                }
                case 5: {
                    return this.createEllipsoid(code);
                }
                case 6: {
                    return this.createPrimeMeridian(code);
                }
                case 7: {
                    return this.createCoordinateOperation(code);
                }
                case 8: {
                    return this.createOperationMethod(code);
                }
                case 9: {
                    return this.createParameterDescriptor(code);
                }
                case 10: {
                    break;
                }
                default: {
                    throw new AssertionError(found);
                }
            }
        }
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends Factory, R extends IdentifiedObject> R create(FactoryCall<F, R> constructor, F factory, Map<String, Object> properties) throws FactoryException {
        ThreadLocal<CRSAuthorityFactory> caller = ParameterizedTransformBuilder.CREATOR;
        CRSAuthorityFactory old = caller.get();
        caller.set(this.owner);
        try {
            R r = constructor.create(factory, properties);
            return r;
        }
        finally {
            if (old != null) {
                caller.set(old);
            } else {
                caller.remove();
            }
        }
    }

    private static GeodeticObjectFactory extended(ObjectFactory factory) {
        return factory instanceof GeodeticObjectFactory ? (GeodeticObjectFactory)factory : GeodeticObjectFactory.provider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        CoordinateReferenceSystem returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.CRS, "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, DEPRECATED, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, BASE_CRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM \"Coordinate Reference System\" WHERE COORD_REF_SYS_CODE = ?", code);){
            while (result.next()) {
                FactoryCall<CRSFactory, CoordinateReferenceSystem> constructor;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String area = EPSGDataAccess.getOptionalString(result, 3);
                String scope = EPSGDataAccess.getOptionalString(result, 4);
                String remarks = EPSGDataAccess.getOptionalString(result, 5);
                boolean deprecated = this.getBoolean(result, 6);
                String type = this.getString((Comparable<?>)((Object)code), result, 7);
                switch (type.toLowerCase(Locale.US)) {
                    case "geocentric": {
                        Object c;
                        Object datum;
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String datumCode = this.getString((Comparable<?>)((Object)code), result, 9);
                        CoordinateSystem cs = this.owner.createCoordinateSystem((String)csCode);
                        Object datumOrEnsemble = this.owner.createGeodeticDatum(datumCode);
                        DefaultDatumEnsemble ensemble = DatumOrEnsemble.asEnsemble(datumOrEnsemble).orElse(null);
                        Object object = datum = ensemble == null ? datumOrEnsemble : null;
                        if (cs instanceof CartesianCS) {
                            c = (CartesianCS)cs;
                            constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$1(ensemble, (GeodeticDatum)datum, (CartesianCS)c, arg_0, arg_1);
                            break;
                        }
                        if (cs instanceof SphericalCS) {
                            c = (SphericalCS)cs;
                            constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$2(ensemble, (GeodeticDatum)datum, (SphericalCS)c, arg_0, arg_1);
                            break;
                        }
                        throw new FactoryDataException(this.error().getString((short)66, (Object)cs.getName()));
                    }
                    case "geographic 2d": 
                    case "geographic 3d": {
                        GeodeticDatum datumOrEnsemble;
                        Object csCode = this.getInteger((Comparable<?>)((Object)code), result, 8);
                        String datumCode = EPSGDataAccess.getOptionalString(result, 9);
                        if (datumCode == null) {
                            String baseCode = this.getString(code, result, 10, 9);
                            datumOrEnsemble = this.owner.createGeographicCRS(baseCode).getDatum();
                        } else {
                            datumOrEnsemble = this.owner.createGeodeticDatum(datumCode);
                        }
                        if (this.replaceDeprecatedCS) {
                            csCode = EPSGDataAccess.replaceDeprecatedCS((Integer)csCode);
                        }
                        EllipsoidalCS cs = this.owner.createEllipsoidalCS(((Integer)csCode).toString());
                        DefaultDatumEnsemble ensemble = DatumOrEnsemble.asEnsemble(datumOrEnsemble).orElse(null);
                        Object datum = ensemble == null ? datumOrEnsemble : null;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$3(ensemble, (GeodeticDatum)datum, cs, arg_0, arg_1);
                        break;
                    }
                    case "projected": {
                        CoordinateReferenceSystem baseCRS;
                        Conversion fromBase;
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String baseCode = this.getString((Comparable<?>)((Object)code), result, 10);
                        String opCode = this.getString((Comparable<?>)((Object)code), result, 11);
                        try {
                            fromBase = (Conversion)this.owner.createCoordinateOperation(opCode);
                        }
                        catch (ClassCastException e) {
                            throw (NoSuchAuthorityCodeException)this.noSuchAuthorityCode(Conversion.class, opCode).initCause((Throwable)e);
                        }
                        if (deprecated) {
                            boolean old = this.quiet;
                            try {
                                this.quiet = true;
                                this.replaceDeprecatedCS = true;
                                baseCRS = this.createCoordinateReferenceSystem(baseCode);
                            }
                            finally {
                                this.replaceDeprecatedCS = false;
                                this.quiet = old;
                            }
                        } else {
                            baseCRS = this.owner.createCoordinateReferenceSystem(baseCode);
                        }
                        CartesianCS cs = this.owner.createCartesianCS((String)csCode);
                        constructor = (factory, metadata) -> {
                            if (baseCRS instanceof GeodeticCRS) {
                                return factory.createProjectedCRS(metadata, (GeographicCRS)baseCRS, fromBase, cs);
                            }
                            return factory.createDerivedCRS(metadata, baseCRS, fromBase, (CoordinateSystem)cs);
                        };
                        if (!deprecated) break;
                        Object c = constructor;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$6((FactoryCall)c, arg_0, arg_1);
                        break;
                    }
                    case "vertical": {
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String datumCode = this.getString((Comparable<?>)((Object)code), result, 9);
                        CoordinateSystem cs = this.owner.createVerticalCS((String)csCode);
                        Object datumOrEnsemble = this.owner.createVerticalDatum(datumCode);
                        DefaultDatumEnsemble ensemble = DatumOrEnsemble.asEnsemble((VerticalDatum)datumOrEnsemble).orElse(null);
                        Object datum = ensemble == null ? datumOrEnsemble : null;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$7(ensemble, (VerticalDatum)datum, (VerticalCS)cs, arg_0, arg_1);
                        break;
                    }
                    case "time": 
                    case "temporal": {
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String datumCode = this.getString((Comparable<?>)((Object)code), result, 9);
                        CoordinateSystem cs = this.owner.createTimeCS((String)csCode);
                        Object datumOrEnsemble = this.owner.createTemporalDatum(datumCode);
                        DefaultDatumEnsemble ensemble = DatumOrEnsemble.asEnsemble((TemporalDatum)datumOrEnsemble).orElse(null);
                        Object datum = ensemble == null ? datumOrEnsemble : null;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$8(ensemble, (TemporalDatum)datum, (TimeCS)cs, arg_0, arg_1);
                        break;
                    }
                    case "engineering": {
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String datumCode = this.getString((Comparable<?>)((Object)code), result, 9);
                        CoordinateSystem cs = this.owner.createCoordinateSystem((String)csCode);
                        Object datumOrEnsemble = this.owner.createEngineeringDatum(datumCode);
                        DefaultDatumEnsemble ensemble = DatumOrEnsemble.asEnsemble((EngineeringDatum)datumOrEnsemble).orElse(null);
                        Object datum = ensemble == null ? datumOrEnsemble : null;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$9(ensemble, (EngineeringDatum)datum, cs, arg_0, arg_1);
                        break;
                    }
                    case "parametric": {
                        Object csCode = this.getString((Comparable<?>)((Object)code), result, 8);
                        String datumCode = this.getString((Comparable<?>)((Object)code), result, 9);
                        CoordinateSystem cs = this.owner.createParametricCS((String)csCode);
                        Object datumOrEnsemble = this.owner.createParametricDatum(datumCode);
                        DefaultDatumEnsemble ensemble = null;
                        Object datum = ensemble == null ? datumOrEnsemble : null;
                        constructor = (arg_0, arg_1) -> EPSGDataAccess.lambda$createCoordinateReferenceSystem$10((DefaultParametricDatum)datum, ensemble, (DefaultParametricCS)cs, arg_0, arg_1);
                        break;
                    }
                    case "compound": {
                        String code1 = this.getString((Comparable<?>)((Object)code), result, 12);
                        String code2 = this.getString((Comparable<?>)((Object)code), result, 13);
                        CoordinateReferenceSystem crs1 = this.owner.createCoordinateReferenceSystem(code1);
                        CoordinateReferenceSystem crs2 = this.owner.createCoordinateReferenceSystem(code2);
                        constructor = (factory, metadata) -> factory.createCompoundCRS(metadata, new CoordinateReferenceSystem[]{crs1, crs2});
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)182, (Object)type));
                    }
                }
                Map<String, Object> properties = this.createProperties(TableInfo.CRS, epsg, name, null, area, scope, remarks, deprecated);
                CoordinateReferenceSystem crs = this.create(constructor, this.owner.crsFactory, properties);
                returnValue = this.ensureSingleton((Object)crs, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateReferenceSystem.class, (Comparable<?>)((Object)code), exception);
        }
        catch (ClassCastException exception) {
            throw new FactoryDataException(exception.getLocalizedMessage(), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Datum createDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        Datum returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.DATUM, "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, ANCHOR_EPOCH, FRAME_REFERENCE_EPOCH, PUBLICATION_DATE, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, DEPRECATED, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE, REALIZATION_METHOD_CODE, CONVENTIONAL_RS_CODE FROM \"Datum\" WHERE DATUM_CODE = ?", code);){
            while (result.next()) {
                FactoryCall<DatumFactory, Datum> constructor;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3);
                String anchor = EPSGDataAccess.getOptionalString(result, 4);
                Temporal epoch = EPSGDataAccess.getOptionalEpoch(result, 5);
                Temporal dynamic = EPSGDataAccess.getOptionalEpoch(result, 6);
                Temporal publish = EPSGDataAccess.getOptionalTemporal(result, 7, "createDatum");
                String area = EPSGDataAccess.getOptionalString(result, 8);
                String scope = EPSGDataAccess.getOptionalString(result, 9);
                String remarks = EPSGDataAccess.getOptionalString(result, 10);
                boolean deprecated = this.getBoolean(result, 11);
                Integer convRSCode = EPSGDataAccess.getOptionalInteger(result, 15);
                switch (type.toLowerCase(Locale.US)) {
                    case "dynamic geodetic": 
                    case "geodetic": {
                        String ellipsoidCode = this.getString((Comparable<?>)((Object)code), result, 12);
                        String meridianCode = this.getString((Comparable<?>)((Object)code), result, 13);
                        Ellipsoid ellipsoid = this.owner.createEllipsoid(ellipsoidCode);
                        PrimeMeridian meridian = this.owner.createPrimeMeridian(meridianCode);
                        constructor = (factory, metadata) -> dynamic != null ? EPSGDataAccess.extended((ObjectFactory)factory).createGeodeticDatum(metadata, ellipsoid, meridian, dynamic) : factory.createGeodeticDatum(metadata, ellipsoid, meridian);
                        break;
                    }
                    case "vertical": {
                        VerticalDatumType method = this.getRealizationMethod(EPSGDataAccess.getOptionalInteger(result, 14));
                        constructor = (factory, metadata) -> dynamic != null ? EPSGDataAccess.extended((ObjectFactory)factory).createVerticalDatum(metadata, method, dynamic) : factory.createVerticalDatum(metadata, method);
                        break;
                    }
                    case "temporal": {
                        Temporal originDate;
                        if (Strings.isNullOrEmpty((String)anchor)) {
                            throw new FactoryDataException(this.resources().getString((short)14));
                        }
                        try {
                            originDate = LenientDateFormat.parseBest((CharSequence)anchor);
                        }
                        catch (RuntimeException e) {
                            throw new FactoryDataException(this.resources().getString((short)14), e);
                        }
                        constructor = (factory, metadata) -> factory.createTemporalDatum(metadata, TemporalDate.toDate((Temporal)originDate));
                        break;
                    }
                    case "engineering": {
                        constructor = DatumFactory::createEngineeringDatum;
                        break;
                    }
                    case "parametric": {
                        constructor = (factory, metadata) -> EPSGDataAccess.extended((ObjectFactory)factory).createParametricDatum(metadata);
                        break;
                    }
                    case "ensemble": {
                        constructor = this.createDatumEnsemble(epsg);
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)182, (Object)type));
                    }
                }
                IdentifiedObject conventionalRS = this.createConventionalRS(convRSCode);
                Map<String, Object> properties = this.createProperties(TableInfo.DATUM, epsg, name, null, area, scope, remarks, deprecated);
                properties.put("anchorDefinition", anchor);
                properties.put("anchorEpoch", epoch);
                properties.put("publicationDate", publish);
                properties.put("conventionalRS", conventionalRS);
                properties.values().removeIf(Objects::isNull);
                Datum datum = constructor.create(this.owner.datumFactory, properties);
                returnValue = this.ensureSingleton((Object)datum, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Datum.class, (Comparable<?>)((Object)code), exception);
        }
        catch (DateTimeException exception) {
            throw new FactoryDataException(exception.getLocalizedMessage(), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Datum.class, code);
        }
        return returnValue;
    }

    private FactoryCall<DatumFactory, DefaultDatumEnsemble<?>> createDatumEnsemble(Integer code) throws SQLException, FactoryException {
        double max = Double.NaN;
        try (ResultSet result = this.executeQueryForCodes("Datum Ensemble", "SELECT ENSEMBLE_ACCURACY FROM \"Datum Ensemble\" WHERE DATUM_ENSEMBLE_CODE = ?", code);){
            while (result.next()) {
                double value = this.getDouble(code, result, 1);
                if (!Double.isNaN(max) && !(value > max)) continue;
                max = value;
            }
        }
        PositionalAccuracy accuracy = PositionalAccuracyConstant.ensemble(max);
        List<Datum> members = this.createComponents(GeodeticAuthorityFactory::createDatum, "Datum Ensemble Member", "SELECT DATUM_CODE FROM \"Datum Ensemble Member\" WHERE DATUM_ENSEMBLE_CODE = ? ORDER BY DATUM_SEQUENCE", code);
        return (factory, metadata) -> EPSGDataAccess.extended((ObjectFactory)factory).createDatumEnsemble(metadata, members, accuracy);
    }

    private <C extends IdentifiedObject> List<C> createComponents(Proxy<C> constructor, String table, String sql, Integer parent) throws SQLException, FactoryException {
        ArrayList<String> codes = new ArrayList<String>();
        try (ResultSet result = this.executeQueryForCodes(table, sql, parent);){
            while (result.next()) {
                codes.add(this.getString(parent, result, 1));
            }
        }
        ArrayList<C> members = new ArrayList<C>(codes.size());
        for (String code : codes) {
            members.add(constructor.create(this.owner, code));
        }
        return members;
    }

    private IdentifiedObject createConventionalRS(Integer code) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        if (code == null) {
            return null;
        }
        Long cacheKey = EPSGDataAccess.cacheKey(4, code);
        IdentifiedObject returnValue = (IdentifiedObject)this.localCache.get(cacheKey);
        if (returnValue == null) {
            try (ResultSet result = this.executeQueryForCodes(TableInfo.CONVENTIONAL_RS.table, "SELECT CONVENTIONAL_RS_CODE, CONVENTIONAL_RS_NAME, REMARKS, DEPRECATED FROM \"Conventional RS\" WHERE CONVENTIONAL_RS_CODE = ?", code);){
                while (result.next()) {
                    Integer epsg = this.getInteger(code, result, 1);
                    String name = this.getString(code, result, 2);
                    String remarks = EPSGDataAccess.getOptionalString(result, 3);
                    boolean deprecated = this.getBoolean(result, 4);
                    Map<String, Object> properties = this.createProperties(TableInfo.CONVENTIONAL_RS, epsg, name, null, null, null, remarks, deprecated);
                    returnValue = this.ensureSingleton(new AbstractIdentifiedObject(properties), returnValue, code);
                    if (!result.isClosed()) continue;
                    break;
                }
            }
            this.localCache.put(cacheKey, returnValue);
        }
        return returnValue;
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        Ellipsoid returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.ELLIPSOID, "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS, DEPRECATED FROM \"Ellipsoid\" WHERE ELLIPSOID_CODE = ?", code);){
            while (result.next()) {
                Ellipsoid ellipsoid;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                double semiMajorAxis = this.getDouble((Comparable<?>)((Object)code), result, 3);
                double inverseFlattening = EPSGDataAccess.getOptionalDouble(result, 4);
                double semiMinorAxis = EPSGDataAccess.getOptionalDouble(result, 5);
                String uom_code = this.getString((Comparable<?>)((Object)code), result, 6);
                String remarks = EPSGDataAccess.getOptionalString(result, 7);
                boolean deprecated = this.getBoolean(result, 8);
                Unit unit = this.owner.createUnit(uom_code).asType(Length.class);
                boolean useSemiMinor = Double.isNaN(inverseFlattening);
                if (useSemiMinor && Double.isNaN(semiMinorAxis)) {
                    String column = result.getMetaData().getColumnName(3);
                    throw new FactoryDataException(this.error().getString((short)145, (Object)code, (Object)column));
                }
                Map<String, Object> properties = this.createProperties(TableInfo.ELLIPSOID, epsg, name, null, null, null, remarks, deprecated);
                if (useSemiMinor) {
                    ellipsoid = this.owner.datumFactory.createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
                } else {
                    if (!Double.isNaN(semiMinorAxis)) {
                        LogRecord record = this.resources().createLogRecord(Level.WARNING, (short)1, "EPSG:" + code);
                        Logging.completeAndLog((Logger)LOGGER, EPSGDataAccess.class, (String)"createEllipsoid", (LogRecord)record);
                    }
                    ellipsoid = this.owner.datumFactory.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
                }
                returnValue = this.ensureSingleton((Object)ellipsoid, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Ellipsoid.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        PrimeMeridian returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.PRIME_MERIDIAN, "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS, DEPRECATED FROM \"Prime Meridian\" WHERE PRIME_MERIDIAN_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                double longitude = this.getDouble((Comparable<?>)((Object)code), result, 3);
                String uom_code = this.getString((Comparable<?>)((Object)code), result, 4);
                String remarks = EPSGDataAccess.getOptionalString(result, 5);
                boolean deprecated = this.getBoolean(result, 6);
                Unit unit = this.owner.createUnit(uom_code).asType(Angle.class);
                PrimeMeridian primeMeridian = this.owner.datumFactory.createPrimeMeridian(this.createProperties(TableInfo.PRIME_MERIDIAN, epsg, name, null, null, null, remarks, deprecated), longitude, unit);
                returnValue = this.ensureSingleton((Object)primeMeridian, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(PrimeMeridian.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Extent createExtent(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        DefaultExtent returnValue = null;
        ArrayList<Map.Entry<DefaultVerticalExtent, Integer>> deferred = new ArrayList<Map.Entry<DefaultVerticalExtent, Integer>>();
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.EXTENT, "SELECT EXTENT_CODE, EXTENT_NAME, EXTENT_DESCRIPTION, BBOX_SOUTH_BOUND_LAT, BBOX_NORTH_BOUND_LAT, BBOX_WEST_BOUND_LON, BBOX_EAST_BOUND_LON, VERTICAL_EXTENT_MIN, VERTICAL_EXTENT_MAX, VERTICAL_EXTENT_CRS_CODE, TEMPORAL_EXTENT_BEGIN, TEMPORAL_EXTENT_END, DEPRECATED FROM \"Extent\" WHERE EXTENT_CODE = ?", code);){
            while (result.next()) {
                Integer n = EPSGDataAccess.getOptionalInteger(result, 1);
                String name = EPSGDataAccess.getOptionalString(result, 2);
                String description = EPSGDataAccess.getOptionalString(result, 3);
                double ymin = EPSGDataAccess.getOptionalDouble(result, 4);
                double ymax = EPSGDataAccess.getOptionalDouble(result, 5);
                double xmin = EPSGDataAccess.getOptionalDouble(result, 6);
                double xmax = EPSGDataAccess.getOptionalDouble(result, 7);
                double zmin = EPSGDataAccess.getOptionalDouble(result, 8);
                double zmax = EPSGDataAccess.getOptionalDouble(result, 9);
                Temporal tmin = EPSGDataAccess.getOptionalTemporal(result, 11, "createExtent");
                Temporal tmax = EPSGDataAccess.getOptionalTemporal(result, 12, "createExtent");
                boolean deprecated = this.getBoolean(result, 13);
                DefaultGeographicBoundingBox bbox = null;
                if (!(Double.isNaN(ymin) && Double.isNaN(ymax) && Double.isNaN(xmin) && Double.isNaN(xmax))) {
                    if (ymin > ymax) {
                        double t = ymin;
                        ymin = ymax;
                        ymax = t;
                    }
                    bbox = new DefaultGeographicBoundingBox(xmin, xmax, ymin, ymax);
                }
                DefaultVerticalExtent vertical = null;
                if (!Double.isNaN(zmin) || !Double.isNaN(zmax)) {
                    QueryID c;
                    vertical = new DefaultVerticalExtent(zmin, zmax, null);
                    Integer crs = EPSGDataAccess.getOptionalInteger(result, 10);
                    if (crs != null && !(c = new QueryID("Coordinate Reference System", new int[]{crs}, this.currentSingletonQuery)).isAlreadyInProgress()) {
                        deferred.add(Map.entry(vertical, crs));
                    }
                }
                DefaultTemporalExtent temporal = null;
                if (tmin != null || tmax != null) {
                    temporal = new DefaultTemporalExtent(tmin, tmax);
                }
                DefaultExtent extent = new DefaultExtent((CharSequence)description, (GeographicExtent)bbox, (VerticalExtent)vertical, (TemporalExtent)temporal);
                if (n != null && name != null) {
                    ReferenceIdentifier identifier = this.createIdentifier(TableInfo.EXTENT, n, name, null, this.getLocale(), deprecated);
                    extent.getGeographicElements().add(new DefaultGeographicDescription((Identifier)identifier));
                }
                if (extent.isEmpty()) continue;
                returnValue = this.ensureSingleton((Object)extent, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Extent.class, (Comparable<?>)((Object)code), exception);
        }
        catch (DateTimeException exception) {
            throw new FactoryDataException(exception.getLocalizedMessage(), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        for (Map.Entry entry : deferred) {
            ((DefaultVerticalExtent)entry.getKey()).setVerticalCRS(this.owner.createVerticalCRS(((Integer)entry.getValue()).toString()));
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Extent.class, code);
        }
        returnValue.transitionTo(ModifiableMetadata.State.FINAL);
        return returnValue;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        CoordinateSystem returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.CS, "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS, DEPRECATED FROM \"Coordinate System\" WHERE COORD_SYS_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3);
                int dimension = this.getInteger((Comparable<?>)((Object)code), result, 4);
                String remarks = EPSGDataAccess.getOptionalString(result, 5);
                boolean deprecated = this.getBoolean(result, 6);
                CoordinateSystemAxis[] axes = (CoordinateSystemAxis[])this.createComponents(GeodeticAuthorityFactory::createCoordinateSystemAxis, "AxisOrder", "SELECT COORD_AXIS_CODE FROM \"Coordinate Axis\" WHERE COORD_SYS_CODE = ? ORDER BY COORD_AXIS_ORDER", epsg).toArray(CoordinateSystemAxis[]::new);
                if (axes.length != dimension) {
                    throw new FactoryDataException(this.error().getString((short)100, (Object)axes.length, (Object)dimension));
                }
                Map<String, Object> properties = this.createProperties(TableInfo.CS, epsg, name, null, null, null, remarks, deprecated);
                CSFactory csFactory = this.owner.csFactory;
                Object cs = null;
                switch (type.toLowerCase(Locale.US)) {
                    case "ellipsoidal": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createEllipsoidalCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createEllipsoidalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "cartesian": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createCartesianCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createCartesianCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "spherical": {
                        switch (dimension) {
                            case 2: {
                                cs = EPSGDataAccess.extended((ObjectFactory)csFactory).createSphericalCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createSphericalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "vertical": 
                    case "gravity-related": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createVerticalCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "time": 
                    case "temporal": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createTimeCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "parametric": {
                        switch (dimension) {
                            case 1: {
                                cs = EPSGDataAccess.extended((ObjectFactory)csFactory).createParametricCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "linear": {
                        switch (dimension) {
                            case 1: {
                                cs = csFactory.createLinearCS(properties, axes[0]);
                            }
                        }
                        break;
                    }
                    case "polar": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createPolarCS(properties, axes[0], axes[1]);
                            }
                        }
                        break;
                    }
                    case "cylindrical": {
                        switch (dimension) {
                            case 3: {
                                cs = csFactory.createCylindricalCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    case "affine": {
                        switch (dimension) {
                            case 2: {
                                cs = csFactory.createAffineCS(properties, axes[0], axes[1]);
                                break;
                            }
                            case 3: {
                                cs = csFactory.createAffineCS(properties, axes[0], axes[1], axes[2]);
                            }
                        }
                        break;
                    }
                    default: {
                        throw new FactoryDataException(this.error().getString((short)182, (Object)type));
                    }
                }
                if (cs == null) {
                    throw new FactoryDataException(this.resources().getString((short)64, type));
                }
                returnValue = this.ensureSingleton((Object)cs, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateSystem.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        CoordinateSystemAxis returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.AXIS, "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM \"Coordinate Axis\" WHERE COORD_AXIS_CODE = ?", code);){
            while (result.next()) {
                AxisDirection direction;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                Integer nameCode = this.getInteger((Comparable<?>)((Object)code), result, 2);
                String orientation = this.getString((Comparable<?>)((Object)code), result, 3);
                String abbreviation = this.getString((Comparable<?>)((Object)code), result, 4);
                String uom_code = this.getString((Comparable<?>)((Object)code), result, 5);
                try {
                    direction = CoordinateSystems.parseAxisDirection(orientation);
                }
                catch (IllegalArgumentException exception) {
                    throw new FactoryDataException(exception.getLocalizedMessage(), exception);
                }
                AxisName an = this.getAxisName(nameCode);
                CoordinateSystemAxis axis = this.owner.csFactory.createCoordinateSystemAxis(this.createProperties(TableInfo.AXIS, epsg, an.name, an.description, null, null, an.remarks, false), abbreviation, direction, this.owner.createUnit(uom_code));
                returnValue = this.ensureSingleton((Object)axis, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateSystemAxis.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code);
        }
        return returnValue;
    }

    private AxisName getAxisName(Integer code) throws FactoryException, SQLException {
        assert (Thread.holdsLock(this));
        Long cacheKey = EPSGDataAccess.cacheKey(3, code);
        AxisName returnValue = (AxisName)((Object)this.localCache.get(cacheKey));
        if (returnValue == null) {
            try (ResultSet result = this.executeQueryForCodes("Coordinate Axis Name", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM \"Coordinate Axis Name\" WHERE COORD_AXIS_NAME_CODE = ?", code);){
                while (result.next()) {
                    String name = this.getString(code, result, 1);
                    String description = EPSGDataAccess.getOptionalString(result, 2);
                    String remarks = EPSGDataAccess.getOptionalString(result, 3);
                    AxisName axis = new AxisName(name, description, remarks);
                    returnValue = this.ensureSingleton(axis, returnValue, code);
                }
            }
            if (returnValue == null) {
                throw this.noSuchAuthorityCode(AxisName.class, String.valueOf(code));
            }
            this.localCache.put(cacheKey, (Object)returnValue);
        }
        return returnValue;
    }

    private VerticalDatumType getRealizationMethod(Integer code) throws FactoryException, SQLException {
        assert (Thread.holdsLock(this));
        if (code == null) {
            return VerticalDatumType.GEOIDAL;
        }
        Long cacheKey = EPSGDataAccess.cacheKey(2, code);
        VerticalDatumType returnValue = (VerticalDatumType)this.localCache.get(cacheKey);
        if (returnValue == null && code != null) {
            try (ResultSet result = this.executeQueryForCodes("Datum Realization Method", "SELECT REALIZATION_METHOD_NAME FROM \"Datum Realization Method\" WHERE REALIZATION_METHOD_CODE = ?", code);){
                while (result.next()) {
                    String name = this.getString(code, result, 1);
                    returnValue = this.ensureSingleton(VerticalDatumTypes.fromMethod(name), returnValue, code);
                }
            }
            if (returnValue == null) {
                throw this.noSuchAuthorityCode(VerticalDatumType.class, String.valueOf(code));
            }
            this.localCache.put(cacheKey, returnValue);
        }
        return returnValue;
    }

    @Override
    public synchronized Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        Unit returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.UNIT, "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE, UNIT_OF_MEAS_NAME FROM \"Unit of Measure\" WHERE UOM_CODE = ?", code);){
            while (result.next()) {
                Unit unit;
                int source = this.getInteger((Comparable<?>)((Object)code), result, 1);
                double b = EPSGDataAccess.getOptionalDouble(result, 2);
                double c = EPSGDataAccess.getOptionalDouble(result, 3);
                int target = this.getInteger((Comparable<?>)((Object)code), result, 4);
                if (source == target) {
                    boolean pb;
                    boolean bl = pb = b != 1.0;
                    if (pb || c != 1.0) {
                        throw new FactoryDataException(this.error().getString((short)85, (Object)(pb ? "FACTOR_B" : "FACTOR_C"), (Object)(pb ? b : c)));
                    }
                }
                if ((unit = Units.valueOfEPSG((int)source)) == null) {
                    Unit base = Units.valueOfEPSG((int)target);
                    if (base != null && !Double.isNaN(b) && !Double.isNaN(c)) {
                        unit = Units.multiply((Unit)base, (double)b, (double)c);
                    } else {
                        try {
                            unit = Units.valueOf((String)this.getString((Comparable<?>)((Object)code), result, 5));
                        }
                        catch (MeasurementParseException e) {
                            throw new FactoryDataException(this.error().getString((short)183, (Object)code), e);
                        }
                    }
                }
                returnValue = this.ensureSingleton((Object)unit, (Object)returnValue, (Comparable<?>)((Object)code));
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(Unit.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Unit.class, code);
        }
        return returnValue;
    }

    private void getParameterType(int parameter, Map<String, String> options) throws SQLException {
        try (ResultSet result = this.executeQueryForCodes("Parameter Type", "SELECT PARAM_VALUE_FILE_REF FROM \"Coordinate_Operation Parameter Value\" WHERE PARAM_VALUE_FILE_REF IS NOT NULL AND (PARAMETER_CODE = ?)", parameter);){
            while (result.next()) {
                String element = EPSGDataAccess.getOptionalString(result, 1);
                if (element == null || element.isBlank()) continue;
                options.put(PARAMETER_TYPE_OPTION, URI_TYPE);
                return;
            }
        }
    }

    private void getParameterUnit(int parameter, Map<String, String> options, Unit<?> dimension) throws SQLException, FactoryException {
        try (ResultSet result = this.executeQueryForCodes("Parameter Unit", "SELECT UOM_CODE FROM \"Coordinate_Operation Parameter Value\" WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC", parameter);){
            while (result.next()) {
                Unit<?> candidate;
                String uom_code = EPSGDataAccess.getOptionalString(result, 1);
                if (uom_code == null) continue;
                if (dimension != null && !(candidate = this.owner.createUnit(uom_code)).isCompatible(dimension)) continue;
                options.put(UOM_CODE_OPTION, uom_code);
                return;
            }
        }
    }

    private void getSignReversal(int parameter, Map<String, String> options) throws SQLException {
        try (ResultSet result = this.executeQueryForCodes("Sign Reversal", "SELECT DISTINCT PARAM_SIGN_REVERSAL FROM \"Coordinate_Operation Parameter Usage\" WHERE (PARAMETER_CODE = ?)", parameter);){
            Boolean reversibility = null;
            while (result.next()) {
                Boolean value = this.getOptionalBoolean(result, 1);
                if (value == null) {
                    return;
                }
                if (reversibility == null) {
                    reversibility = value;
                    continue;
                }
                if (reversibility.equals(value)) continue;
                return;
            }
            if (reversibility != null) {
                options.put(SIGN_REVERSAL_OPTION, reversibility.toString());
            }
        }
    }

    @Override
    public synchronized ParameterDescriptor<?> createParameterDescriptor(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        HashMap<String, String> options = new HashMap<String, String>(4);
        String base = EPSGDataAccess.separateOptions(code, options);
        if (!options.isEmpty()) {
            try {
                ParameterDescriptor<?> generic = this.owner.createParameterDescriptor(base);
                HashMap<String, Object> metadata = new HashMap<String, Object>(IdentifiedObjects.getProperties(generic, new String[0]));
                ParameterDescriptor<?> returnValue = this.createParameterDescriptor(Integer.valueOf(base), metadata, options);
                return generic.equals(returnValue) ? generic : returnValue;
            }
            catch (SQLException exception) {
                throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)code), exception);
            }
        }
        ParameterDescriptor<?> returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.PARAMETER, "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION, DEPRECATED FROM \"Coordinate_Operation Parameter\" WHERE PARAMETER_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String description = EPSGDataAccess.getOptionalString(result, 3);
                boolean deprecated = this.getBoolean(result, 4);
                this.getParameterUnit(epsg, options, null);
                this.getParameterType(epsg, options);
                this.getSignReversal(epsg, options);
                Map<String, Object> properties = this.createProperties(TableInfo.PARAMETER, epsg, name, description, null, null, null, deprecated);
                returnValue = this.createParameterDescriptor(epsg, properties, options);
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private ParameterDescriptor<?> createParameterDescriptor(Integer code, Map<String, Object> metadata, Map<String, String> options) throws SQLException, FactoryException {
        Class type;
        MeasurementRange valueDomain = null;
        if (EPSG_CODE_PARAMETERS.contains(code)) {
            type = Integer.class;
        } else {
            type = URI_TYPE.equalsIgnoreCase(options.remove(PARAMETER_TYPE_OPTION)) ? String.class : Double.class;
            String uom_code = options.remove(UOM_CODE_OPTION);
            if (uom_code != null) {
                valueDomain = MeasurementRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false, this.owner.createUnit(uom_code));
            }
        }
        metadata.put("remarks", SignReversalComment.of(SQLUtilities.parseBoolean((String)options.remove(SIGN_REVERSAL_OPTION))));
        return new DefaultParameterDescriptor<Object>(metadata, 1, 1, type, (Range<?>)valueDomain, null, null);
    }

    private List<Parameter> createParameterValues(Integer operation, int method) throws FactoryException, SQLException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        try (ResultSet result = this.executeQueryForCodes("Coordinate_Operation Parameter Value", "SELECT CV.PARAMETER_CODE, CV.PARAMETER_VALUE, CV.PARAM_VALUE_FILE_REF, CV.UOM_CODE, CU.PARAM_SIGN_REVERSAL FROM \"Coordinate_Operation Parameter Value\" AS CV INNER JOIN \"Coordinate_Operation Parameter Usage\" AS CU ON (CV.PARAMETER_CODE = CU.PARAMETER_CODE) AND (CV.COORD_OP_METHOD_CODE = CU.COORD_OP_METHOD_CODE) WHERE CV.COORD_OP_METHOD_CODE = ? AND CV.COORD_OP_CODE = ? ORDER BY CU.SORT_ORDER", method, operation);){
            while (result.next()) {
                Integer descriptor = this.getInteger(operation, result, 1);
                double value = EPSGDataAccess.getOptionalDouble(result, 2);
                String reference = Double.isNaN(value) ? this.getString(operation, result, 3) : null;
                String uom_code = EPSGDataAccess.getOptionalString(result, 4);
                Unit<?> unit = uom_code != null ? this.owner.createUnit(uom_code) : null;
                Boolean reversibility = this.getOptionalBoolean(result, 5);
                LinkedHashMap<String, String> options = new LinkedHashMap<String, String>(8);
                if (reference != null) {
                    options.put(PARAMETER_TYPE_OPTION, URI_TYPE);
                }
                this.getParameterUnit(descriptor, options, unit);
                if (reversibility != null) {
                    options.put(SIGN_REVERSAL_OPTION, reversibility.toString());
                }
                String codeWithOptions = EPSGDataAccess.codeWithOptions(descriptor.toString(), options);
                parameters.add(new Parameter(this.owner.createParameterDescriptor(codeWithOptions), reference, value, unit));
            }
        }
        return parameters;
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        OperationMethod returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.METHOD, "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, REMARKS, DEPRECATED FROM \"Coordinate_Operation Method\" WHERE COORD_OP_METHOD_CODE = ?", code);){
            while (result.next()) {
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String remarks = EPSGDataAccess.getOptionalString(result, 3);
                boolean deprecated = this.getBoolean(result, 4);
                ParameterDescriptor[] descriptors = (ParameterDescriptor[])this.createComponents(GeodeticAuthorityFactory::createParameterDescriptor, "Coordinate_Operation Parameter Usage", "SELECT PARAMETER_CODE FROM \"Coordinate_Operation Parameter Usage\" WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER", epsg).toArray(ParameterDescriptor[]::new);
                Map<String, Object> properties = this.createProperties(TableInfo.METHOD, epsg, name, null, null, null, remarks, deprecated);
                Object identifier = properties.remove("identifiers");
                DefaultParameterDescriptorGroup params = new DefaultParameterDescriptorGroup(properties, 1, 1, (GeneralParameterDescriptor[])descriptors);
                properties.putAll(IdentifiedObjects.getProperties(params, new String[0]));
                properties.put("identifiers", identifier);
                DefaultOperationMethod method = new DefaultOperationMethod(properties, params);
                returnValue = this.ensureSingleton((Object)method, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(OperationMethod.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        CoordinateOperation returnValue = null;
        QueryID previousSingletonQuery = this.currentSingletonQuery;
        try (ResultSet result = this.executeSingletonQuery(TableInfo.OPERATION, "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS, DEPRECATED FROM \"Coordinate_Operation\" WHERE COORD_OP_CODE = ?", code);){
            while (result.next()) {
                FactoryCall<CoordinateOperationFactory, CoordinateOperation> constructor;
                ParameterValueGroup parameterValues;
                OperationMethod operationMethod;
                String targetCode;
                String sourceCode;
                Integer epsg = this.getInteger((Comparable<?>)((Object)code), result, 1);
                String name = this.getString((Comparable<?>)((Object)code), result, 2);
                String type = this.getString((Comparable<?>)((Object)code), result, 3).toLowerCase(Locale.US);
                boolean isTransformation = type.equals("transformation");
                boolean isConversion = type.equals("conversion");
                boolean isConcatenated = type.equals("concatenated operation");
                if (isConversion) {
                    sourceCode = EPSGDataAccess.getOptionalString(result, 4);
                    targetCode = EPSGDataAccess.getOptionalString(result, 5);
                } else {
                    sourceCode = this.getString((Comparable<?>)((Object)code), result, 4);
                    targetCode = this.getString((Comparable<?>)((Object)code), result, 5);
                }
                Integer methodCode = isConcatenated ? EPSGDataAccess.getOptionalInteger(result, 6) : this.getInteger((Comparable<?>)((Object)code), result, 6);
                String version = EPSGDataAccess.getOptionalString(result, 7);
                double accuracy = EPSGDataAccess.getOptionalDouble(result, 8);
                String area = EPSGDataAccess.getOptionalString(result, 9);
                String scope = EPSGDataAccess.getOptionalString(result, 10);
                String remarks = EPSGDataAccess.getOptionalString(result, 11);
                boolean deprecated = this.getBoolean(result, 12);
                CoordinateReferenceSystem sourceCRS = sourceCode == null ? null : this.owner.createCoordinateReferenceSystem(sourceCode);
                CoordinateReferenceSystem targetCRS = targetCode == null ? null : this.owner.createCoordinateReferenceSystem(targetCode);
                boolean isDeferred = Semaphores.METADATA_ONLY.get();
                if (methodCode != null && !isDeferred) {
                    OperationMethod generic = this.owner.createOperationMethod(methodCode.toString());
                    List<Parameter> values = this.createParameterValues(epsg, methodCode);
                    operationMethod = Parameter.recreateIfChanged(generic, values);
                    parameterValues = operationMethod.getParameters().createValue();
                    for (Parameter element : values) {
                        try {
                            element.setValue(parameterValues);
                        }
                        catch (RuntimeException | URISyntaxException exception) {
                            String message = this.error().getString((short)23, (Object)element.name());
                            throw new FactoryDataException(message, exception);
                        }
                    }
                } else {
                    operationMethod = null;
                    parameterValues = null;
                }
                Class operationType = null;
                if (isDeferred) {
                    constructor = (factory, metadata) -> new DeferredCoordinateOperation(metadata, sourceCRS, targetCRS, this.owner);
                } else if (isConversion && (sourceCRS == null || targetCRS == null)) {
                    constructor = (factory, metadata) -> factory.createDefiningConversion(metadata, operationMethod, parameterValues);
                } else if (isConcatenated) {
                    CoordinateOperation[] operations = (CoordinateOperation[])this.createComponents(GeodeticAuthorityFactory::createCoordinateOperation, "Coordinate_Operation Path", "SELECT SINGLE_OPERATION_CODE FROM \"Coordinate_Operation Path\" WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP", epsg).toArray(CoordinateOperation[]::new);
                    constructor = (factory, metadata) -> {
                        if (factory instanceof DefaultCoordinateOperationFactory) {
                            return ((DefaultCoordinateOperationFactory)factory).createConcatenatedOperation(metadata, sourceCRS, targetCRS, operations);
                        }
                        return factory.createConcatenatedOperation(metadata, operations);
                    };
                } else {
                    Class<? extends SingleOperation> s;
                    ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(this.owner.mtFactory, null);
                    builder.setParameters(parameterValues, true);
                    builder.setSourceAxes(sourceCRS);
                    builder.setTargetAxes(targetCRS);
                    MathTransform mt = builder.create();
                    operationType = isTransformation ? Transformation.class : (isConversion ? Conversion.class : SingleOperation.class);
                    OperationMethod provider = builder.getMethod().orElse(null);
                    if (provider instanceof DefaultOperationMethod && (s = ((DefaultOperationMethod)provider).getOperationType()) != null && operationType.isAssignableFrom(s)) {
                        operationType = s.asSubclass(SingleOperation.class);
                    }
                    constructor = (factory, metadata) -> {
                        if (factory instanceof DefaultCoordinateOperationFactory) {
                            return ((DefaultCoordinateOperationFactory)factory).createSingleOperation(metadata, sourceCRS, targetCRS, null, operationMethod, mt);
                        }
                        throw new UnsupportedOperationException(this.error().getString((short)197, (Object)factory.getClass()));
                    };
                }
                Map<String, Object> properties = this.createProperties(TableInfo.OPERATION, epsg, name, null, area, scope, remarks, deprecated);
                properties.put("operationType", operationType);
                properties.put("parameters", parameterValues);
                properties.put("operationVersion", version);
                properties.put("coordinateOperationAccuracy", PositionalAccuracyConstant.transformation(accuracy));
                CoordinateOperation operation = this.create(constructor, this.owner.copFactory, properties);
                returnValue = this.ensureSingleton((Object)operation, (Object)returnValue, (Comparable<?>)((Object)code));
                if (!result.isClosed()) continue;
                break;
            }
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)code), exception);
        }
        finally {
            this.currentSingletonQuery = previousSingletonQuery;
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateOperation.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCRS);
        String label = sourceCRS + " \u21e8 " + targetCRS;
        CoordinateOperationSet set = new CoordinateOperationSet(this.owner);
        try {
            int[] pair = this.toPrimaryKeys(null, sourceCRS, targetCRS);
            boolean searchTransformations = false;
            do {
                String sql;
                String key;
                if (searchTransformations) {
                    key = "TransformationFromCRS";
                    sql = "SELECT COORD_OP_CODE FROM \"Coordinate_Operation\" WHERE DEPRECATED=FALSE AND SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY COORD_OP_ACCURACY ASC NULLS LAST";
                } else {
                    key = "ConversionFromCRS";
                    sql = "SELECT PROJECTION_CONV_CODE FROM \"Coordinate Reference System\" WHERE BASE_CRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                Integer targetKey = searchTransformations ? null : Integer.valueOf(pair[1]);
                try (ResultSet result = this.executeQueryForCodes(key, sql, pair);){
                    while (result.next()) {
                        set.addAuthorityCode(this.getString((Comparable<?>)((Object)label), result, 1), targetKey);
                    }
                }
            } while (searchTransformations = !searchTransformations);
            List<String> codes = Arrays.asList(set.getAuthorityCodes());
            this.sort(TableInfo.OPERATION, codes, Integer::parseInt).ifPresent(sorted -> set.setAuthorityCodes((String[])sorted.mapToObj(Integer::toString).toArray(String[]::new)));
        }
        catch (SQLException exception) {
            throw this.databaseFailure(CoordinateOperation.class, (Comparable<?>)((Object)label), exception);
        }
        if (!Semaphores.METADATA_ONLY.get()) {
            set.resolve(1);
        }
        return set;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        try {
            if (this.connection.isClosed()) {
                throw new FactoryException(this.error().getString((short)31));
            }
            return new EPSGCodeFinder(this);
        }
        catch (SQLException exception) {
            throw new FactoryException(exception.getLocalizedMessage(), (Throwable)Exceptions.unwrap((Exception)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized <C extends Comparable<?>> Optional<IntStream> sort(TableInfo source, Collection<C> codes, ToIntFunction<C> parser) throws SQLException, FactoryException {
        int size = codes.size();
        if (size > 1) {
            try {
                ObjectPertinence[] elements = new ObjectPertinence[size];
                ArrayList<String> extents = new ArrayList<String>();
                String actualTable = this.translator.toActualTableName(source.table);
                int count = 0;
                for (Comparable code : codes) {
                    int key;
                    try {
                        key = parser.applyAsInt(code);
                    }
                    catch (NumberFormatException e) {
                        EPSGDataAccess.unexpectedException("sort", e);
                        continue;
                    }
                    if (this.translator.isUsageTableFound()) {
                        this.getUsages(actualTable, key, extents, null);
                    } else if (source.areaOfUse) {
                        try (ResultSet result = this.executeQueryForCodes("Area", "SELECT AREA_OF_USE_CODE FROM \"" + source.table + "\" WHERE " + source.codeColumn + "=?", key);){
                            while (result.next()) {
                                extents.add(this.getString(code, result, 1));
                            }
                        }
                    }
                    ObjectPertinence element = new ObjectPertinence(key, extents, this.owner);
                    extents.clear();
                    try (ResultSet result = this.executeMetadataQuery("Supersession", "SELECT SUPERSEDED_BY FROM \"Supersession\" WHERE OBJECT_TABLE_NAME=? AND OBJECT_CODE=? ORDER BY SUPERSESSION_YEAR DESC", actualTable, key);){
                        while (result.next()) {
                            int replacement = result.getInt(1);
                            if (result.wasNull()) continue;
                            element.replacedBy.add(replacement);
                        }
                    }
                    elements[count++] = element;
                }
                if (ObjectPertinence.sort(elements)) {
                    Optional<IntStream> optional = Optional.of(Arrays.stream(elements).mapToInt(p -> p.code));
                    return optional;
                }
            }
            finally {
                PreparedStatement stmt = this.statements.remove("Area");
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return Optional.empty();
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> type, String code) {
        return new NoSuchAuthorityCodeException(this.resources().getString((short)49, "EPSG", type, code), "EPSG", code, code);
    }

    final FactoryException databaseFailure(Class<?> type, Comparable<?> code, SQLException cause) {
        return new FactoryException(this.error().getString((short)33, type, code), (Throwable)Exceptions.unwrap((Exception)cause));
    }

    private Errors error() {
        return Errors.forLocale((Locale)this.getLocale());
    }

    private Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    private static void unexpectedException(String method, Exception exception) {
        Logging.unexpectedException((Logger)LOGGER, EPSGDataAccess.class, (String)method, (Throwable)exception);
    }

    final synchronized boolean canClose() {
        boolean can = true;
        SQLException error = null;
        if (!this.authorityCodes.isEmpty()) {
            System.gc();
            Iterator<CloseableReference> it = this.authorityCodes.values().iterator();
            while (it.hasNext()) {
                CloseableReference reference = it.next();
                if (!reference.published) {
                    it.remove();
                    try {
                        reference.close();
                    }
                    catch (SQLException e) {
                        if (error == null) {
                            error = e;
                        }
                        error.addSuppressed(e);
                    }
                    reference.clear();
                    continue;
                }
                if (JDK16.refersTo((Reference)reference, null)) {
                    it.remove();
                    continue;
                }
                can = false;
            }
        }
        if (error != null) {
            EPSGDataAccess.unexpectedException("canClose", error);
        }
        return can;
    }

    @Override
    public synchronized void close() throws FactoryException {
        SQLException exception = null;
        Iterator<PreparedStatement> ip = this.statements.values().iterator();
        while (ip.hasNext()) {
            try {
                ip.next().close();
            }
            catch (SQLException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            ip.remove();
        }
        Iterator<CloseableReference> it = this.authorityCodes.values().iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (SQLException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            it.remove();
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            if (exception == null) {
                exception = e;
            }
            e.addSuppressed(exception);
        }
        if (exception != null) {
            throw new FactoryException((Throwable)Exceptions.unwrap((Exception)exception));
        }
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$10(DefaultParametricDatum datum, DefaultDatumEnsemble ensemble, DefaultParametricCS cs, CRSFactory factory, Map metadata) throws FactoryException {
        return EPSGDataAccess.extended((ObjectFactory)factory).createParametricCRS(metadata, datum, ensemble, cs);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$9(DefaultDatumEnsemble ensemble, EngineeringDatum datum, CoordinateSystem cs, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createEngineeringCRS(metadata, datum, ensemble, cs) : factory.createEngineeringCRS(metadata, datum, cs);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$8(DefaultDatumEnsemble ensemble, TemporalDatum datum, TimeCS cs, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createTemporalCRS(metadata, datum, ensemble, cs) : factory.createTemporalCRS(metadata, datum, cs);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$7(DefaultDatumEnsemble ensemble, VerticalDatum datum, VerticalCS cs, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createVerticalCRS(metadata, datum, ensemble, cs) : factory.createVerticalCRS(metadata, datum, cs);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$6(FactoryCall c, CRSFactory factory, Map metadata) throws FactoryException {
        return (CoordinateReferenceSystem)Semaphores.SUSPEND_PARAMETER_CHECK.execute(() -> (CoordinateReferenceSystem)c.create(factory, metadata));
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$3(DefaultDatumEnsemble ensemble, GeodeticDatum datum, EllipsoidalCS cs, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createGeographicCRS(metadata, datum, ensemble, cs) : factory.createGeographicCRS(metadata, datum, cs);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$2(DefaultDatumEnsemble ensemble, GeodeticDatum datum, SphericalCS c, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createGeodeticCRS(metadata, datum, (DefaultDatumEnsemble<GeodeticDatum>)ensemble, c) : factory.createGeocentricCRS(metadata, datum, c);
    }

    private static /* synthetic */ CoordinateReferenceSystem lambda$createCoordinateReferenceSystem$1(DefaultDatumEnsemble ensemble, GeodeticDatum datum, CartesianCS c, CRSFactory factory, Map metadata) throws FactoryException {
        return ensemble != null ? EPSGDataAccess.extended((ObjectFactory)factory).createGeodeticCRS(metadata, datum, (DefaultDatumEnsemble<GeodeticDatum>)ensemble, c) : factory.createGeocentricCRS(metadata, datum, c);
    }

    private static final class QueryID {
        private final String table;
        private final int[] codes;
        final QueryID previous;

        QueryID(String table, int[] codes, QueryID previous) {
            this.table = table;
            this.codes = codes;
            this.previous = previous;
        }

        final boolean isAlreadyInProgress() {
            QueryID p = this.previous;
            while (p != null) {
                if (this.table.equals(p.table) && Arrays.equals(this.codes, p.codes)) {
                    return true;
                }
                p = p.previous;
            }
            return false;
        }

        public String toString() {
            return this.table + ": " + Arrays.toString(this.codes);
        }
    }

    @FunctionalInterface
    private static interface FactoryCall<F extends Factory, R extends IdentifiedObject> {
        public R create(F var1, Map<String, Object> var2) throws FactoryException;
    }

    @FunctionalInterface
    private static interface Proxy<C extends IdentifiedObject> {
        public C create(GeodeticAuthorityFactory var1, String var2) throws SQLException, FactoryException;
    }

    private static final class Parameter {
        final ParameterDescriptor<?> descriptor;
        final String reference;
        final double value;
        final Unit<?> unit;

        Parameter(ParameterDescriptor<?> descriptor, String reference, double value, Unit<?> unit) {
            this.descriptor = descriptor;
            this.reference = reference;
            this.value = value;
            this.unit = unit;
        }

        static OperationMethod recreateIfChanged(OperationMethod generic, List<Parameter> values) {
            List existing = generic.getParameters().descriptors();
            ParameterDescriptor[] descriptors = new ParameterDescriptor[values.size()];
            boolean changed = false;
            for (int i = 0; i < descriptors.length; ++i) {
                ParameterDescriptor descriptor = values.get((int)i).descriptor;
                GeneralParameterDescriptor other = (GeneralParameterDescriptor)existing.get(i);
                if (descriptor.equals((Object)other)) {
                    descriptor = (ParameterDescriptor)other;
                } else {
                    changed = true;
                }
                descriptors[i] = descriptor;
            }
            if (changed) {
                generic = new DefaultOperationMethod(IdentifiedObjects.getProperties((IdentifiedObject)generic, new String[0]), new DefaultParameterDescriptorGroup(IdentifiedObjects.getProperties((IdentifiedObject)generic.getParameters(), new String[0]), 1, 1, (GeneralParameterDescriptor[])descriptors));
            }
            return generic;
        }

        final void setValue(ParameterValueGroup target) throws URISyntaxException {
            ParameterValue param = target.parameter(this.name());
            if (this.reference != null) {
                param.setValue((Object)new URI(null, this.reference, null));
                return;
            }
            if (!(this.unit == null || Units.UNITY.equals(this.unit) && param.getUnit() == null)) {
                param.setValue(this.value, this.unit);
                return;
            }
            param.setValue(this.value);
        }

        final String name() {
            return this.descriptor.getName().getCode();
        }

        public String toString() {
            StringBuilder s = new StringBuilder(this.name()).append(" = ");
            if (this.reference != null) {
                s.append(this.reference);
            } else {
                s.append(this.value);
                if (this.unit != null) {
                    s.append(' ').append(this.unit);
                }
            }
            return s.toString();
        }
    }
}

