/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryIdentifier;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.LazySynchronizedIterator;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.LazySet;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.SetOfUnknownSize;
import org.apache.sis.util.internal.shared.AbstractIterator;
import org.apache.sis.util.internal.shared.DefinitionURI;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;

public class MultiAuthoritiesFactory
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final EnumMap<AuthorityFactoryIdentifier.Type, Iterable<? extends AuthorityFactory>> providers = new EnumMap(AuthorityFactoryIdentifier.Type.class);
    private final ConcurrentMap<AuthorityFactoryIdentifier, AuthorityFactory> factories;
    private final AtomicInteger isIterationCompleted;
    private volatile Set<String> codeSpaces;
    private volatile boolean isLenient;
    private final Map<AuthorityFactoryIdentifier, Boolean> warnings;

    public MultiAuthoritiesFactory(Iterable<? extends CRSAuthorityFactory> crsFactories, Iterable<? extends CSAuthorityFactory> csFactories, Iterable<? extends DatumAuthorityFactory> datumFactories, Iterable<? extends CoordinateOperationAuthorityFactory> copFactories) {
        this.providers.put(AuthorityFactoryIdentifier.Type.CRS, crsFactories);
        this.providers.put(AuthorityFactoryIdentifier.Type.CS, csFactories);
        this.providers.put(AuthorityFactoryIdentifier.Type.DATUM, datumFactories);
        this.providers.put(AuthorityFactoryIdentifier.Type.OPERATION, copFactories);
        int nullMask = 0;
        Iterator<Map.Entry<AuthorityFactoryIdentifier.Type, Iterable<? extends AuthorityFactory>>> it = this.providers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AuthorityFactoryIdentifier.Type, Iterable<? extends AuthorityFactory>> entry = it.next();
            if (entry.getValue() != null) continue;
            nullMask |= 1 << entry.getKey().ordinal();
            it.remove();
        }
        this.isIterationCompleted = new AtomicInteger(nullMask);
        this.factories = new ConcurrentHashMap<AuthorityFactoryIdentifier, AuthorityFactory>();
        this.warnings = new HashMap<AuthorityFactoryIdentifier, Boolean>();
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        this.isLenient = lenient;
    }

    @Override
    public Citation getAuthority() {
        return null;
    }

    public Set<String> getAuthorityCodes(final Class<? extends IdentifiedObject> type) throws FactoryException {
        return new SetOfUnknownSize<String>(this){
            private final Map<AuthorityFactory, Set<String>> cache = new IdentityHashMap<AuthorityFactory, Set<String>>();
            private int size = -1;
            private final AuthorityFactoryProxy<Boolean> contains = new AuthorityFactoryProxy<Boolean>(Boolean.class, AuthorityFactoryIdentifier.Type.ANY){

                @Override
                Boolean createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
                    try {
                        return this.getAuthorityCodes(factory).contains(code);
                    }
                    catch (BackingStoreException e) {
                        throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
                    }
                }

                @Override
                AuthorityFactoryProxy<Boolean> specialize(String typeName) {
                    return this;
                }
            };
            final /* synthetic */ MultiAuthoritiesFactory this$0;
            {
                this.this$0 = this$0;
            }

            public Iterator<String> iterator() {
                return new AbstractIterator<String>(){
                    private final Iterator<AuthorityFactory> factories;
                    private Iterator<String> codes;
                    private String prefix;
                    private final Set<String> done;
                    {
                        this.factories = this$0.getAllFactories();
                        this.codes = Collections.emptyIterator();
                        this.done = new HashSet<String>();
                    }

                    public boolean hasNext() {
                        while (this.next == null) {
                            while (!this.codes.hasNext()) {
                                do {
                                    if (!this.factories.hasNext()) {
                                        return false;
                                    }
                                    AuthorityFactory factory = this.factories.next();
                                    this.codes = this.getAuthorityCodes(factory).iterator();
                                    this.prefix = MultiAuthoritiesFactory.getCodeSpace(factory);
                                } while (!this.done.add(this.prefix));
                            }
                            this.next = this.codes.next();
                        }
                        return true;
                    }

                    public String next() {
                        Object code = (String)super.next();
                        if (this.prefix != null && ((String)code).indexOf(58) < 0) {
                            code = this.prefix + ":" + (String)code;
                        }
                        return code;
                    }
                };
            }

            final Set<String> getAuthorityCodes(AuthorityFactory factory) {
                Set codes = this.cache.get(factory);
                if (codes == null) {
                    try {
                        codes = factory.getAuthorityCodes(type);
                    }
                    catch (FactoryException e) {
                        throw new BackingStoreException((Throwable)e);
                    }
                    if (this.cache.put(factory, codes) != null) {
                        throw new ConcurrentModificationException();
                    }
                }
                return codes;
            }

            protected int characteristics() {
                return 257;
            }

            protected OptionalInt sizeIfKnown() {
                return this.size >= 0 ? OptionalInt.of(this.size) : OptionalInt.empty();
            }

            public int size() {
                if (this.size < 0) {
                    int n = 0;
                    HashSet<String> done = new HashSet<String>();
                    Iterator<AuthorityFactory> it = this.this$0.getAllFactories();
                    while (it.hasNext()) {
                        AuthorityFactory factory = it.next();
                        if (!done.add(MultiAuthoritiesFactory.getCodeSpace(factory))) continue;
                        n += this.getAuthorityCodes(factory).size();
                    }
                    this.size = n;
                }
                return this.size;
            }

            public boolean isEmpty() {
                if (this.size == -1) {
                    Iterator<AuthorityFactory> it = this.this$0.getAllFactories();
                    while (it.hasNext()) {
                        if (this.getAuthorityCodes(it.next()).isEmpty()) continue;
                        this.size = -2;
                        return false;
                    }
                    this.size = 0;
                }
                return this.size == 0;
            }

            public boolean contains(Object code) {
                if (code instanceof String) {
                    try {
                        return this.this$0.create(this.contains, (String)code);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    }
                    catch (FactoryException e) {
                        throw new BackingStoreException((Throwable)e);
                    }
                }
                return false;
            }

            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> getCodeSpaces() throws FactoryException {
        Set union = this.codeSpaces;
        if (union == null) {
            union = new LinkedHashSet<String>();
            Iterator<AuthorityFactory> it = this.getAllFactories();
            while (it.hasNext()) {
                union.addAll(MultiAuthoritiesFactory.getCodeSpaces(it.next()));
            }
            this.codeSpaces = union = Containers.unmodifiable(union);
        }
        return union;
    }

    private static Set<String> getCodeSpaces(AuthorityFactory factory) throws FactoryException {
        if (factory instanceof GeodeticAuthorityFactory) {
            return ((GeodeticAuthorityFactory)factory).getCodeSpaces();
        }
        try {
            String authority = Citations.toCodeSpace((Citation)factory.getAuthority());
            return authority != null ? Set.of(authority) : Set.of();
        }
        catch (BackingStoreException e) {
            throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
        }
    }

    static String getCodeSpace(AuthorityFactory factory) {
        try {
            return (String)Containers.peekFirst(MultiAuthoritiesFactory.getCodeSpaces(factory));
        }
        catch (FactoryException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    private AuthorityFactory cache(AuthorityFactoryIdentifier identifier, AuthorityFactory factory) {
        AuthorityFactory existing = this.factories.putIfAbsent(identifier.intern(), factory);
        return existing != null ? existing : factory;
    }

    private Iterator<AuthorityFactory> getAllFactories() {
        return new LazySynchronizedIterator(this.providers.values().iterator());
    }

    public final <T extends AuthorityFactory> T getAuthorityFactory(Class<T> type, String authority, String version) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonNull((String)"authority", (Object)authority);
        return (T)((AuthorityFactory)type.cast(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(type, authority, version))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorityFactory getAuthorityFactory(AuthorityFactoryIdentifier request) throws FactoryException {
        int bitmask;
        int doneMask;
        AuthorityFactory factory = (AuthorityFactory)this.factories.get(request);
        if (factory != null) {
            return factory;
        }
        if (request.hasVersion() && (factory = (AuthorityFactory)this.factories.get(request.versionOf(null))) != null) {
            try {
                if (request.versionOf(factory.getAuthority()) == request) {
                    return this.cache(request, factory);
                }
                factory = null;
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
        }
        if (((doneMask = this.isIterationCompleted.get()) & (bitmask = 1 << request.type.ordinal())) == 0) {
            Iterable<? extends AuthorityFactory> provider = this.providers.get((Object)request.type);
            if (provider != null) {
                Iterator<? extends AuthorityFactory> it;
                Iterable<? extends AuthorityFactory> iterable = provider;
                synchronized (iterable) {
                    it = provider.iterator();
                    while (it.hasNext() && (factory = it.next()) == null) {
                    }
                }
                while (factory != null) {
                    for (String namespace : MultiAuthoritiesFactory.getCodeSpaces(factory)) {
                        AuthorityFactory found;
                        AuthorityFactoryIdentifier unversioned = request.unversioned(namespace);
                        AuthorityFactory cached = this.cache(unversioned, factory);
                        Object object = found = request.equals(unversioned) ? cached : null;
                        if (factory != cached || request.hasVersion() && request.isSameAuthority(unversioned)) {
                            try {
                                AuthorityFactoryIdentifier versioned = unversioned.versionOf(factory.getAuthority());
                                if (versioned != unversioned) {
                                    if (factory != cached) {
                                        this.cache(unversioned.versionOf(cached.getAuthority()), cached);
                                    }
                                    cached = this.cache(versioned, factory);
                                }
                                if (factory != cached && this.canLog(versioned)) {
                                    versioned.logConflict(cached);
                                }
                                if (request.equals(versioned)) {
                                    return cached;
                                }
                            }
                            catch (BackingStoreException e) {
                                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
                            }
                        }
                        if (found == null) continue;
                        return found;
                    }
                    factory = null;
                    iterable = provider;
                    synchronized (iterable) {
                        while (it.hasNext() && (factory = it.next()) == null) {
                        }
                    }
                }
            } else if (request.type.isGeneric()) {
                for (Map.Entry<AuthorityFactoryIdentifier.Type, Iterable<? extends AuthorityFactory>> entry : this.providers.entrySet()) {
                    factory = this.getAuthorityFactory(request.newType(entry.getKey()));
                    if (!request.type.api.isInstance(factory)) continue;
                    return factory;
                }
            }
            while (!this.isIterationCompleted.compareAndSet(doneMask, doneMask | bitmask)) {
                doneMask = this.isIterationCompleted.get();
            }
        }
        if (request.hasVersion() && this.isLenient) {
            factory = this.getAuthorityFactory(request.versionOf(null));
            if (this.canLog(request)) {
                request.logFallback();
            }
            return factory;
        }
        String authority = request.getAuthorityAndVersion().toString();
        throw new NoSuchAuthorityFactoryException(Resources.format((short)66, authority), authority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canLog(AuthorityFactoryIdentifier identifier) {
        Map<AuthorityFactoryIdentifier, Boolean> map = this.warnings;
        synchronized (map) {
            if (this.warnings.containsKey(identifier)) {
                return false;
            }
            return this.warnings.putIfAbsent(identifier.intern(), Boolean.TRUE) == null;
        }
    }

    private <T> T create(AuthorityFactoryProxy<? extends T> proxy, String code) throws FactoryException {
        String[] parameters;
        String version;
        String authority;
        ArgumentChecks.ensureNonNull((String)"code", (Object)code);
        DefinitionURI uri = DefinitionURI.parse((String)code);
        if (uri != null) {
            DefinitionURI[] components;
            Class type = proxy.type;
            proxy = proxy.specialize(uri.type);
            if (uri.code == null && (components = uri.components) != null) {
                for (int i = 0; i < components.length; ++i) {
                    if (components[i] != null) continue;
                    throw new NoSuchAuthorityCodeException(Resources.format((short)78, i + 1, uri.isHTTP ? 1 : 0), uri.authority, null, uri.toString());
                }
                if (proxy != null) {
                    type = proxy.type;
                }
                return this.combine(type, components, uri.isHTTP);
            }
            if (uri.authority == null) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)39, code), null, uri.code, code);
            }
            authority = uri.authority;
            version = uri.version;
            code = uri.code;
            parameters = uri.parameters;
            if (code == null || proxy == null) {
                String s = uri.toString();
                String message = code == null ? Errors.format((short)106, (Object)s, (Object)"code") : Resources.format((short)4, type, "urn:ogc:def:" + uri.type);
                throw new NoSuchAuthorityCodeException(message, authority, code, s);
            }
        } else {
            int afterVersion;
            int afterAuthority = code.indexOf(58);
            int end = CharSequences.skipTrailingWhitespaces((CharSequence)code, (int)0, (int)afterAuthority);
            int start = CharSequences.skipLeadingWhitespaces((CharSequence)code, (int)0, (int)end);
            if (start >= end) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)39, code), null, code);
            }
            authority = code.substring(start, end);
            String string = version = (start = CharSequences.skipLeadingWhitespaces((CharSequence)code, (int)(++afterAuthority), (int)(afterVersion = code.indexOf(58, afterAuthority)))) < (end = CharSequences.skipTrailingWhitespaces((CharSequence)code, (int)start, (int)afterVersion)) && !code.startsWith("0", start) ? code.substring(start, end) : null;
            if (version != null && !Character.isUnicodeIdentifierPart(version.codePointAt(0))) {
                throw new NoSuchAuthorityCodeException(Errors.format((short)93, (Object)version), authority, code);
            }
            code = CharSequences.trimWhitespaces((CharSequence)code, (int)Math.max(afterAuthority, afterVersion + 1), (int)code.length()).toString();
            parameters = null;
        }
        if (parameters != null || code.indexOf(44) >= 0) {
            StringBuilder buffer = new StringBuilder(authority.length() + code.length() + 1).append(authority).append(':').append(code);
            if (parameters != null) {
                for (String p : parameters) {
                    buffer.append(',').append(p);
                }
            }
            code = buffer.toString();
        }
        return proxy.createFromAPI(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(proxy.factoryType, authority, version)), code);
    }

    @Override
    public Optional<InternationalString> getDescriptionText(Class<? extends IdentifiedObject> type, String code) throws FactoryException {
        return Optional.ofNullable(this.create(new AuthorityFactoryProxy.Description(type), code));
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CRS, code);
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, code);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, code);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, code);
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, code);
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, code);
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, code);
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, code);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, code);
    }

    @Override
    @Deprecated(since="1.5")
    public ImageCRS createImageCRS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, code);
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DATUM, code);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, code);
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, code);
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, code);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, code);
    }

    @Override
    @Deprecated(since="1.5")
    public ImageDatum createImageDatum(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, code);
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOID, code);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, code);
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.EXTENT, code);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, code);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, code);
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, code);
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TIME_CS, code);
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, code);
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, code);
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, code);
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.POLAR_CS, code);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.AXIS, code);
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.UNIT, code);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PARAMETER, code);
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        try {
            return this.create(AuthorityFactoryProxy.METHOD, code);
        }
        catch (NoSuchAuthorityCodeException e) {
            try {
                return DefaultMathTransformFactory.provider().getOperationMethod(code);
            }
            catch (NoSuchIdentifierException s) {
                e.addSuppressed((Throwable)s);
                throw e;
            }
        }
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OPERATION, code);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        Deferred deferred = new Deferred();
        CoordinateOperationAuthorityFactory factory = this.create(deferred, sourceCRS);
        String source = deferred.code;
        if (this.create(deferred, targetCRS) == factory) {
            return factory.createFromCoordinateReferenceSystemCodes(source, deferred.code);
        }
        LogRecord record = Resources.forLocale(null).createLogRecord(Level.WARNING, (short)34, sourceCRS, targetCRS);
        Logging.completeAndLog((Logger)LOGGER, MultiAuthoritiesFactory.class, (String)"createFromCoordinateReferenceSystemCodes", (LogRecord)record);
        return super.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
    }

    private <T> T combine(Class<T> type, DefinitionURI[] references, boolean isHTTP) throws FactoryException {
        CoordinateReferenceSystem[] components;
        Class<CoordinateReferenceSystem> componentType;
        AuthorityFactoryIdentifier.Type requestedType;
        if (CoordinateReferenceSystem.class.isAssignableFrom(type)) {
            requestedType = AuthorityFactoryIdentifier.Type.CRS;
            componentType = CoordinateReferenceSystem.class;
            components = new CoordinateReferenceSystem[references.length];
        } else if (CoordinateOperation.class.isAssignableFrom(type)) {
            requestedType = AuthorityFactoryIdentifier.Type.OPERATION;
            componentType = CoordinateOperation.class;
            components = new CoordinateOperation[references.length];
        } else {
            throw new FactoryException(Resources.format((short)79, type));
        }
        String expected = NameMeaning.toObjectType(componentType);
        for (int i = 0; i < references.length; ++i) {
            DefinitionURI ref = references[i];
            IdentifiedObject component = this.createObject(ref.toString());
            if (!(componentType == null || componentType.isInstance(component) && expected.equalsIgnoreCase(ref.type))) {
                componentType = null;
                components = (IdentifiedObject[])Arrays.copyOf(components, components.length, IdentifiedObject[].class);
            }
            components[i] = component;
        }
        CoordinateReferenceSystem combined = null;
        switch (requestedType) {
            case OPERATION: {
                if (componentType == null) break;
                CoordinateOperation[] steps = (CoordinateOperation[])components;
                String name = IdentifiedObjects.getIdentifierOrName((IdentifiedObject)steps[0]) + " \u27f6 " + IdentifiedObjects.getIdentifierOrName((IdentifiedObject)steps[steps.length - 1]);
                combined = DefaultCoordinateOperationFactory.provider().createConcatenatedOperation(Map.of("name", name), steps);
                break;
            }
            case CRS: {
                CoordinateSystem cs;
                if (componentType != null) {
                    combined = CRS.compound(components);
                    break;
                }
                if (isHTTP || (cs = MultiAuthoritiesFactory.remove(references, (IdentifiedObject[])components, CoordinateSystem.class)) == null) break;
                Datum datum = MultiAuthoritiesFactory.remove(references, (IdentifiedObject[])components, Datum.class);
                if (datum != null) {
                    if (!ArraysExt.allEquals((Object[])references, null)) break;
                    combined = MultiAuthoritiesFactory.combine((GeodeticDatum)datum, cs);
                    break;
                }
                CoordinateReferenceSystem baseCRS = MultiAuthoritiesFactory.remove(references, (IdentifiedObject[])components, CoordinateReferenceSystem.class);
                CoordinateOperation op = MultiAuthoritiesFactory.remove(references, (IdentifiedObject[])components, CoordinateOperation.class);
                if (!ArraysExt.allEquals((Object[])references, null) || !(op instanceof Conversion)) break;
                combined = MultiAuthoritiesFactory.combine(baseCRS, (Conversion)op, cs);
            }
        }
        if (combined == null) {
            throw new FactoryException(Resources.format((short)80));
        }
        IdentifiedObject existing = this.newIdentifiedObjectFinder().findSingleton((IdentifiedObject)combined);
        return type.cast(existing != null ? existing : combined);
    }

    private static <T> T remove(DefinitionURI[] references, IdentifiedObject[] components, Class<T> type) {
        String expected = NameMeaning.toObjectType(type);
        for (int i = 0; i < references.length; ++i) {
            DefinitionURI ref = references[i];
            if (ref == null || !expected.equalsIgnoreCase(ref.type)) continue;
            references[i] = null;
            return type.cast(components[i]);
        }
        return null;
    }

    private static GeodeticCRS combine(GeodeticDatum datum, CoordinateSystem cs) throws FactoryException {
        Map<String, ?> properties = IdentifiedObjects.getProperties((IdentifiedObject)datum, "identifiers");
        GeodeticObjectFactory factory = GeodeticObjectFactory.provider();
        if (datum instanceof GeodeticDatum) {
            if (cs instanceof EllipsoidalCS) {
                return factory.createGeographicCRS(properties, datum, (EllipsoidalCS)cs);
            }
            if (cs instanceof SphericalCS) {
                return factory.createGeocentricCRS(properties, datum, (SphericalCS)cs);
            }
        }
        return null;
    }

    private static GeneralDerivedCRS combine(CoordinateReferenceSystem baseCRS, Conversion fromBase, CoordinateSystem cs) throws FactoryException {
        if (baseCRS != null && fromBase.getSourceCRS() == null && fromBase.getTargetCRS() == null) {
            Map<String, ?> properties = IdentifiedObjects.getProperties((IdentifiedObject)fromBase, "identifiers");
            GeodeticObjectFactory factory = GeodeticObjectFactory.provider();
            if (baseCRS instanceof GeographicCRS && cs instanceof CartesianCS) {
                return factory.createProjectedCRS(properties, (GeographicCRS)baseCRS, fromBase, (CartesianCS)cs);
            }
            return factory.createDerivedCRS(properties, baseCRS, fromBase, cs);
        }
        return null;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        for (Map.Entry<AuthorityFactoryIdentifier.Type, Iterable<? extends AuthorityFactory>> entry : this.providers.entrySet()) {
            Iterable<? extends AuthorityFactory> provider;
            Iterable<? extends AuthorityFactory> iterable = provider = entry.getValue();
            synchronized (iterable) {
                if (provider instanceof LazySet) {
                    ((LazySet)((Object)provider)).reload();
                } else if (provider instanceof ServiceLoader) {
                    ((ServiceLoader)provider).reload();
                }
                int type = entry.getKey().ordinal();
                this.applyAndMask(~(1 << type));
                Iterator it = this.factories.keySet().iterator();
                while (it.hasNext()) {
                    if (((AuthorityFactoryIdentifier)it.next()).type.ordinal() != type) continue;
                    it.remove();
                }
            }
        }
        this.applyAndMask((1 << AuthorityFactoryIdentifier.Type.GEODETIC.ordinal()) - 1);
    }

    private void applyAndMask(int mask) {
        int value;
        while (!this.isIterationCompleted.compareAndSet(value = this.isIterationCompleted.get(), value & mask)) {
        }
    }

    private static final class Deferred
    extends AuthorityFactoryProxy<CoordinateOperationAuthorityFactory> {
        String code;

        Deferred() {
            super(CoordinateOperationAuthorityFactory.class, AuthorityFactoryIdentifier.Type.OPERATION);
        }

        @Override
        CoordinateOperationAuthorityFactory createFromAPI(AuthorityFactory factory, String code) throws FactoryException {
            this.code = code;
            return this.opFactory(factory);
        }
    }

    private static final class Finder
    extends IdentifiedObjectFinder {
        private IdentifiedObjectFinder[] finders;

        protected Finder(MultiAuthoritiesFactory factory) throws FactoryException {
            super(factory);
        }

        @Override
        public void setSearchDomain(IdentifiedObjectFinder.Domain domain) {
            super.setSearchDomain(domain);
            if (this.finders != null) {
                for (IdentifiedObjectFinder finder : this.finders) {
                    finder.setSearchDomain(domain);
                }
            }
        }

        @Override
        public void setIgnoringAxes(boolean ignore) {
            super.setIgnoringAxes(ignore);
            if (this.finders != null) {
                for (IdentifiedObjectFinder finder : this.finders) {
                    finder.setIgnoringAxes(ignore);
                }
            }
        }

        private void createFromIdentifiers(AuthorityFactoryIdentifier.Type type, IdentifiedObject object, Iterable<ReferenceIdentifier> identifiers, Set<IdentifiedObject> result) throws FactoryException {
            for (ReferenceIdentifier identifier : identifiers) {
                IdentifiedObject candidate;
                String authority = identifier.getCodeSpace();
                if (authority == null) continue;
                MultiAuthoritiesFactory factory = (MultiAuthoritiesFactory)this.factory;
                try {
                    AuthorityFactoryIdentifier fid = AuthorityFactoryIdentifier.create(type, authority, identifier.getVersion());
                    candidate = this.createAndFilter(factory.getAuthorityFactory(fid), identifier.getCode(), object);
                }
                catch (NoSuchAuthorityCodeException e) {
                    Finder.exceptionOccurred((FactoryException)((Object)e));
                    continue;
                }
                if (candidate == null) continue;
                result.add(candidate);
            }
        }

        @Override
        final Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
            if (this.getSearchDomain() != IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET) {
                for (AuthorityFactoryIdentifier.Type type : AuthorityFactoryIdentifier.Type.values()) {
                    if (!type.isFactoryOf(object)) continue;
                    LinkedHashSet<IdentifiedObject> result = new LinkedHashSet<IdentifiedObject>();
                    this.createFromIdentifiers(type, object, object.getIdentifiers(), result);
                    if (result.isEmpty()) {
                        this.createFromIdentifiers(type, object, Containers.singletonOrEmpty((Object)object.getName()), result);
                        if (result.isEmpty()) break;
                    }
                    return result;
                }
            }
            if (this.finders == null) {
                ArrayList<IdentifiedObjectFinder> list = new ArrayList<IdentifiedObjectFinder>();
                IdentityHashMap<AuthorityFactory, Boolean> unique = new IdentityHashMap<AuthorityFactory, Boolean>();
                Iterator<AuthorityFactory> it = ((MultiAuthoritiesFactory)this.factory).getAllFactories();
                while (it.hasNext()) {
                    IdentifiedObjectFinder finder;
                    AuthorityFactory candidate = it.next();
                    if (!(candidate instanceof GeodeticAuthorityFactory) || unique.put(candidate, Boolean.TRUE) != null || (finder = ((GeodeticAuthorityFactory)candidate).newIdentifiedObjectFinder()) == null) continue;
                    list.add(finder);
                }
                this.finders = (IdentifiedObjectFinder[])list.toArray(IdentifiedObjectFinder[]::new);
            }
            LinkedHashSet<IdentifiedObject> merged = null;
            Set<IdentifiedObject> result = null;
            for (IdentifiedObjectFinder finder : this.finders) {
                finder.setWrapper(this);
                Set<IdentifiedObject> codes = finder.find(object);
                if (codes.isEmpty()) continue;
                if (result == null) {
                    result = codes;
                    continue;
                }
                if (merged == null) {
                    merged = new LinkedHashSet<IdentifiedObject>(result);
                }
                if (!merged.addAll(codes)) continue;
                result = merged;
            }
            return result != null ? result : Set.of();
        }
    }
}

