/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.config;

import java.io.File;
import org.apache.royale.compiler.common.IPathResolver;
import org.apache.royale.utils.FilenameNormalization;

public class ConfigurationPathResolver
implements IPathResolver {
    private String rootDirectory;

    public ConfigurationPathResolver(String rootDirectory) {
        this.rootDirectory = rootDirectory;
        if (rootDirectory == null) {
            throw new NullPointerException("rootDirectory may not be null");
        }
    }

    @Override
    public File resolve(String path) {
        return this.tryResolve(this.rootDirectory, path);
    }

    private File tryResolve(String parent, String name) {
        File file = new File(name);
        if (file.isAbsolute()) {
            return FilenameNormalization.normalize(file);
        }
        return FilenameNormalization.normalize(new File(parent, name));
    }
}

