/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.java.message.MessageImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.commons.lang3.ArrayUtils;
import org.apache.rocketmq.shaded.commons.lang3.StringUtils;

public class MessageBuilderImpl
implements MessageBuilder {
    public static final Pattern TOPIC_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    private String topic = null;
    private byte[] body = null;
    private String tag = null;
    private String messageGroup = null;
    private Long deliveryTimestamp = null;
    private Collection<String> keys = new HashSet<String>();
    private final Map<String, String> properties = new HashMap<String, String>();

    @Override
    public MessageBuilder setTopic(String topic) {
        Preconditions.checkNotNull(topic, "topic should not be null");
        Preconditions.checkArgument(TOPIC_PATTERN.matcher(topic).matches(), "topic does not match the regex [regex=%s]", (Object)TOPIC_PATTERN.pattern());
        this.topic = topic;
        return this;
    }

    @Override
    public MessageBuilder setBody(byte[] body) {
        Preconditions.checkArgument(ArrayUtils.isNotEmpty(body), "body should not be empty");
        this.body = (byte[])body.clone();
        return this;
    }

    @Override
    public MessageBuilder setTag(String tag) {
        Preconditions.checkArgument(StringUtils.isNotBlank(tag), "tag should not be blank");
        Preconditions.checkArgument(!tag.contains("|"), "tag should not contain \"|\"");
        this.tag = tag;
        return this;
    }

    @Override
    public MessageBuilder setKeys(String ... keys) {
        for (String key : keys) {
            Preconditions.checkArgument(StringUtils.isNotBlank(key), "key should not be blank");
        }
        this.keys = new ArrayList<String>();
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public MessageBuilder setMessageGroup(String messageGroup) {
        Preconditions.checkArgument(null == this.deliveryTimestamp, "messageGroup and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument(StringUtils.isNotBlank(messageGroup), "messageGroup should not be blank");
        this.messageGroup = messageGroup;
        return this;
    }

    @Override
    public MessageBuilder setDeliveryTimestamp(long deliveryTimestamp) {
        Preconditions.checkArgument(null == this.messageGroup, "deliveryTimestamp and messageGroup should not be set at same time");
        this.deliveryTimestamp = deliveryTimestamp;
        return this;
    }

    @Override
    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument(StringUtils.isNotBlank(key), "key should not be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank(value), "value should not be blank");
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Message build() {
        Preconditions.checkNotNull(this.topic, "topic has not been set yet");
        Preconditions.checkNotNull(this.body, "body has not been set yet");
        return new MessageImpl(this.topic, this.body, this.tag, this.keys, this.messageGroup, this.deliveryTimestamp, this.properties);
    }
}

