/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.rpc.Signature;
import org.apache.rocketmq.shaded.io.grpc.CallOptions;
import org.apache.rocketmq.shaded.io.grpc.Channel;
import org.apache.rocketmq.shaded.io.grpc.ClientCall;
import org.apache.rocketmq.shaded.io.grpc.ClientInterceptor;
import org.apache.rocketmq.shaded.io.grpc.ForwardingClientCall;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.io.grpc.MethodDescriptor;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class AuthInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthInterceptor.class);
    private final ClientConfiguration clientConfiguration;
    private final ClientId clientId;

    public AuthInterceptor(ClientConfiguration clientConfiguration, ClientId clientId) {
        this.clientConfiguration = clientConfiguration;
        this.clientId = clientId;
    }

    private void customMetadata(Metadata headers) {
        try {
            Metadata metadata = Signature.sign(this.clientConfiguration, this.clientId);
            headers.merge(metadata);
        }
        catch (Throwable t) {
            log.error("Failed to sign headers, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    public <T, E> ClientCall<T, E> interceptCall(MethodDescriptor<T, E> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<T, E>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<E> listener, Metadata headers) {
                AuthInterceptor.this.customMetadata(headers);
                super.start(listener, headers);
            }
        };
    }
}

