/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class WaitNotifyObject {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final ConcurrentHashMap<Long, AtomicBoolean> waitingThreadTable = new ConcurrentHashMap(16);
    protected AtomicBoolean hasNotified = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        boolean needNotify = this.hasNotified.compareAndSet(false, true);
        if (needNotify) {
            WaitNotifyObject waitNotifyObject = this;
            synchronized (waitNotifyObject) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRunning(long interval) {
        if (this.hasNotified.compareAndSet(true, false)) {
            this.onWaitEnd();
            return;
        }
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            try {
                if (this.hasNotified.compareAndSet(true, false)) {
                    this.onWaitEnd();
                    return;
                }
                this.wait(interval);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
            finally {
                this.hasNotified.set(false);
                this.onWaitEnd();
            }
        }
    }

    protected void onWaitEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupAll() {
        boolean needNotify = false;
        for (Map.Entry<Long, AtomicBoolean> entry : this.waitingThreadTable.entrySet()) {
            if (!entry.getValue().compareAndSet(false, true)) continue;
            needNotify = true;
        }
        if (needNotify) {
            WaitNotifyObject waitNotifyObject = this;
            synchronized (waitNotifyObject) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allWaitForRunning(long interval) {
        long currentThreadId = Thread.currentThread().getId();
        AtomicBoolean notified = (AtomicBoolean)ConcurrentHashMapUtils.computeIfAbsent(this.waitingThreadTable, (Object)currentThreadId, k -> new AtomicBoolean(false));
        if (notified.compareAndSet(true, false)) {
            this.onWaitEnd();
            return;
        }
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            try {
                if (notified.compareAndSet(true, false)) {
                    this.onWaitEnd();
                    return;
                }
                this.wait(interval);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
            finally {
                notified.set(false);
                this.onWaitEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromWaitingThreadTable() {
        long currentThreadId = Thread.currentThread().getId();
        WaitNotifyObject waitNotifyObject = this;
        synchronized (waitNotifyObject) {
            this.waitingThreadTable.remove(currentThreadId);
        }
    }
}

