/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.subscription;

import com.alibaba.fastjson2.annotation.JSONField;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.rocketmq.common.SubscriptionGroupAttributes;
import org.apache.rocketmq.remoting.protocol.subscription.GroupRetryPolicy;
import org.apache.rocketmq.remoting.protocol.subscription.SimpleSubscriptionData;

public class SubscriptionGroupConfig {
    private String groupName;
    private boolean consumeEnable = true;
    private boolean consumeFromMinEnable = true;
    private boolean consumeBroadcastEnable = true;
    private boolean consumeMessageOrderly = false;
    private int retryQueueNums = 1;
    private int retryMaxTimes = 16;
    private GroupRetryPolicy groupRetryPolicy = new GroupRetryPolicy();
    private long brokerId = 0L;
    private long whichBrokerWhenConsumeSlowly = 1L;
    private boolean notifyConsumerIdsChangedEnable = true;
    private int groupSysFlag = 0;
    private int consumeTimeoutMinute = 15;
    private Set<SimpleSubscriptionData> subscriptionDataSet;
    private Map<String, String> attributes = new HashMap<String, String>();

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public boolean isConsumeEnable() {
        return this.consumeEnable;
    }

    public void setConsumeEnable(boolean consumeEnable) {
        this.consumeEnable = consumeEnable;
    }

    public boolean isConsumeFromMinEnable() {
        return this.consumeFromMinEnable;
    }

    public void setConsumeFromMinEnable(boolean consumeFromMinEnable) {
        this.consumeFromMinEnable = consumeFromMinEnable;
    }

    public boolean isConsumeBroadcastEnable() {
        return this.consumeBroadcastEnable;
    }

    public void setConsumeBroadcastEnable(boolean consumeBroadcastEnable) {
        this.consumeBroadcastEnable = consumeBroadcastEnable;
    }

    public boolean isConsumeMessageOrderly() {
        return this.consumeMessageOrderly;
    }

    public void setConsumeMessageOrderly(boolean consumeMessageOrderly) {
        this.consumeMessageOrderly = consumeMessageOrderly;
    }

    public int getRetryQueueNums() {
        return this.retryQueueNums;
    }

    public void setRetryQueueNums(int retryQueueNums) {
        this.retryQueueNums = retryQueueNums;
    }

    public int getRetryMaxTimes() {
        return this.retryMaxTimes;
    }

    public void setRetryMaxTimes(int retryMaxTimes) {
        this.retryMaxTimes = retryMaxTimes;
    }

    public GroupRetryPolicy getGroupRetryPolicy() {
        return this.groupRetryPolicy;
    }

    public void setGroupRetryPolicy(GroupRetryPolicy groupRetryPolicy) {
        this.groupRetryPolicy = groupRetryPolicy;
    }

    public long getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(long brokerId) {
        this.brokerId = brokerId;
    }

    public long getWhichBrokerWhenConsumeSlowly() {
        return this.whichBrokerWhenConsumeSlowly;
    }

    public void setWhichBrokerWhenConsumeSlowly(long whichBrokerWhenConsumeSlowly) {
        this.whichBrokerWhenConsumeSlowly = whichBrokerWhenConsumeSlowly;
    }

    public boolean isNotifyConsumerIdsChangedEnable() {
        return this.notifyConsumerIdsChangedEnable;
    }

    public void setNotifyConsumerIdsChangedEnable(boolean notifyConsumerIdsChangedEnable) {
        this.notifyConsumerIdsChangedEnable = notifyConsumerIdsChangedEnable;
    }

    public int getGroupSysFlag() {
        return this.groupSysFlag;
    }

    public void setGroupSysFlag(int groupSysFlag) {
        this.groupSysFlag = groupSysFlag;
    }

    public int getConsumeTimeoutMinute() {
        return this.consumeTimeoutMinute;
    }

    public void setConsumeTimeoutMinute(int consumeTimeoutMinute) {
        this.consumeTimeoutMinute = consumeTimeoutMinute;
    }

    public Set<SimpleSubscriptionData> getSubscriptionDataSet() {
        return this.subscriptionDataSet;
    }

    public void setSubscriptionDataSet(Set<SimpleSubscriptionData> subscriptionDataSet) {
        this.subscriptionDataSet = subscriptionDataSet;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @JSONField(serialize=false, deserialize=false)
    public long getPriorityFactor() {
        String factorStr = null == this.attributes ? null : this.attributes.get(SubscriptionGroupAttributes.PRIORITY_FACTOR_ATTRIBUTE.getName());
        return NumberUtils.toLong((String)factorStr, (long)SubscriptionGroupAttributes.PRIORITY_FACTOR_ATTRIBUTE.getDefaultValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.brokerId ^ this.brokerId >>> 32);
        result = 31 * result + (this.consumeBroadcastEnable ? 1231 : 1237);
        result = 31 * result + (this.consumeEnable ? 1231 : 1237);
        result = 31 * result + (this.consumeFromMinEnable ? 1231 : 1237);
        result = 31 * result + (this.notifyConsumerIdsChangedEnable ? 1231 : 1237);
        result = 31 * result + (this.consumeMessageOrderly ? 1231 : 1237);
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + this.retryMaxTimes;
        result = 31 * result + this.retryQueueNums;
        result = 31 * result + (int)(this.whichBrokerWhenConsumeSlowly ^ this.whichBrokerWhenConsumeSlowly >>> 32);
        result = 31 * result + this.groupSysFlag;
        result = 31 * result + this.consumeTimeoutMinute;
        result = 31 * result + (this.subscriptionDataSet == null ? 0 : this.subscriptionDataSet.hashCode());
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionGroupConfig other = (SubscriptionGroupConfig)obj;
        return new EqualsBuilder().append((Object)this.groupName, (Object)other.groupName).append(this.consumeEnable, other.consumeEnable).append(this.consumeFromMinEnable, other.consumeFromMinEnable).append(this.consumeBroadcastEnable, other.consumeBroadcastEnable).append(this.consumeMessageOrderly, other.consumeMessageOrderly).append(this.retryQueueNums, other.retryQueueNums).append(this.retryMaxTimes, other.retryMaxTimes).append(this.whichBrokerWhenConsumeSlowly, other.whichBrokerWhenConsumeSlowly).append(this.notifyConsumerIdsChangedEnable, other.notifyConsumerIdsChangedEnable).append(this.groupSysFlag, other.groupSysFlag).append(this.consumeTimeoutMinute, other.consumeTimeoutMinute).append(this.subscriptionDataSet, other.subscriptionDataSet).append(this.attributes, other.attributes).isEquals();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupName", (Object)this.groupName).add("consumeEnable", this.consumeEnable).add("consumeFromMinEnable", this.consumeFromMinEnable).add("consumeBroadcastEnable", this.consumeBroadcastEnable).add("consumeMessageOrderly", this.consumeMessageOrderly).add("retryQueueNums", this.retryQueueNums).add("retryMaxTimes", this.retryMaxTimes).add("groupRetryPolicy", (Object)this.groupRetryPolicy).add("brokerId", this.brokerId).add("whichBrokerWhenConsumeSlowly", this.whichBrokerWhenConsumeSlowly).add("notifyConsumerIdsChangedEnable", this.notifyConsumerIdsChangedEnable).add("groupSysFlag", this.groupSysFlag).add("consumeTimeoutMinute", this.consumeTimeoutMinute).add("subscriptionDataSet", this.subscriptionDataSet).add("attributes", this.attributes).toString();
    }
}

